package snakegame.algorithm;

import java.awt.Point;
import java.util.List;

import snakegame.map.Direction;

/**
 * Algoritmo de movimentao.
 * 
 * @author Tecgraf/PUC-Rio
 */
public interface IMoveAlgorithm {

  /**
   * Retorna a direo da cobra. Se o valor for null ento a cobra vai manter
   * sua direo.
   * 
   * @param snake lista de pontos ocupados pela cobra.
   * @param direction direo atual.
   * @param food ponto da comida.
   * @param rows nmero total de linhas.
   * @param columns nmero total de colunas.
   * @return direo da cobra.
   */
  Direction whereShouldIGo(List<Point> snake, Direction direction, Point food,
    int rows, int columns);
}
