package snakegame.action;

import java.awt.event.ActionEvent;

import snakegame.SnakeGame;
import snakegame.session.MapSize;
import snakegame.session.Session;
import csdk.v2.helper.application.AbstractApplicationAction;

/**
 * Ao que modifica o tamanho do mapa.
 * 
 * @author Tecgraf/PUC-Rio
 */
public class ChangeMapSizeAction extends AbstractApplicationAction<SnakeGame> {

  /** Sesso. */
  private final Session session;

  /** Tamanho do mapa. */
  private final MapSize mapSize;

  /**
   * Construtor.
   * 
   * @param application aplicao.
   * @param session sesso.
   * @param mapSize tamanho do mapa.
   */
  public ChangeMapSizeAction(SnakeGame application, Session session,
    MapSize mapSize) {
    super(application);
    this.session = session;
    this.mapSize = mapSize;

    setName(String.format("%s X %s", mapSize.size, mapSize.size));
  }

  /** {@inheritDoc} */
  @Override
  public void actionPerformed(ActionEvent event) {
    session.setMapSize(mapSize);
  }
}
