/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.javautils.gui.crud;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;

public class RegistrationBundle
extends ResourceBundle {
    private final Properties properties = new Properties();
    private final Locale locale;

    private String getResourcePath(Locale locale) {
        String dirName = "resources/bundles/";
        String className = RegistrationBundle.class.getSimpleName();
        String name = locale.getLanguage() + "_" + locale.getCountry();
        String resPath = "resources/bundles/" + className + "_" + name + ".properties";
        return resPath;
    }

    private InputStream getResourceInputStream(Locale locale) {
        String path = this.getResourcePath(locale);
        InputStream stream = RegistrationBundle.class.getResourceAsStream(path);
        return stream;
    }

    public RegistrationBundle(Locale locale) {
        this.locale = locale;
        InputStream stream = this.getResourceInputStream(locale);
        if (stream != null) {
            try {
                this.properties.load(stream);
            }
            catch (IOException e) {
                String locStr = locale.toString();
                String className = this.getClass().getName();
                String msg = className + ": Unsuported native locale: " + locStr;
                System.err.println(msg);
            }
        }
    }

    @Override
    protected Object handleGetObject(String key) {
        if (key == null) {
            throw new NullPointerException("Null key detected!");
        }
        if (!this.properties.containsKey(key)) {
            return "<<" + key + ">>";
        }
        return this.properties.get(key);
    }

    @Override
    public Locale getLocale() {
        return this.locale;
    }

    @Override
    public Enumeration<String> getKeys() {
        Set<String> keys = this.properties.stringPropertyNames();
        Enumeration<String> parentKeys = this.parent.getKeys();
        if (parentKeys != null) {
            keys.addAll(Collections.list(parentKeys));
        }
        Enumeration<String> enumeration = Collections.enumeration(keys);
        return enumeration;
    }
}

