package snakegame.action;

import java.awt.event.ActionEvent;

import csdk.v1_0.helper.application.AbstractApplicationAction;
import snakegame.SnakeGame;
import snakegame.session.Level;
import snakegame.session.Session;

/**
 * Ao que modifica o nvel de dificuldade do jogo.
 *
 * @author Tecgraf/PUC-Rio
 */
public class ChangeDifficultAction
  extends AbstractApplicationAction<SnakeGame> {

  /** Sesso. */
  private Session session;

  /** Nvel de dificuldade. */
  private Level level;

  /**
   * Construtor.
   *
   * @param application aplicao.
   * @param session sesso.
   * @param level nvel de dificuldade.
   */
  public ChangeDifficultAction(SnakeGame application, Session session,
    Level level) {
    super(application);

    this.session = session;
    this.level = level;

    setName(getString(level.key));
  }

  /** {@inheritDoc} */
  @Override
  public void actionPerformed(ActionEvent event) {
    session.setLevel(level);
  }
}
