/*
 * Decompiled with CFR 0.152.
 */
package testealgo;

import csdk.v2.api.command.ICommandInfo;
import java.awt.Component;
import java.awt.Font;
import java.util.Date;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JTextArea;

public class CommandReportFrame
extends JFrame {
    public CommandReportFrame(ICommandInfo info) {
        Integer userTime;
        Integer elapsedTime;
        Integer cpuTime;
        Long endTime;
        Long startTime;
        this.setDefaultCloseOperation(2);
        JTextArea area = new JTextArea();
        area.setLineWrap(true);
        area.setWrapStyleWord(true);
        area.setEditable(false);
        area.setFont(new Font("Monospaced", 0, 12));
        String lineSeparator = "\n";
        StringBuilder buffer = new StringBuilder();
        buffer.append("** Command Info **");
        buffer.append(lineSeparator);
        buffer.append("command id: ");
        buffer.append(info.getCommandId());
        buffer.append(lineSeparator);
        buffer.append("project id: ");
        buffer.append(info.getProjectId());
        buffer.append(lineSeparator);
        buffer.append("description: ");
        buffer.append(info.getDescription());
        buffer.append(lineSeparator);
        buffer.append("execution host: ");
        buffer.append(info.getExecutionHost());
        buffer.append(lineSeparator);
        buffer.append("finalization type: ");
        buffer.append(info.getFinalizationType());
        buffer.append(lineSeparator);
        buffer.append("exit code: ");
        buffer.append(info.getExitCode());
        buffer.append(lineSeparator);
        Integer guiltyNodeId = info.getGuiltyNodeId();
        if (guiltyNodeId != null) {
            buffer.append("guilty node id: ");
            buffer.append(guiltyNodeId);
            buffer.append(lineSeparator);
        }
        if ((startTime = info.getStartTime()) != null) {
            buffer.append("start time: ");
            buffer.append(new Date(startTime));
            buffer.append(lineSeparator);
        }
        if ((endTime = info.getEndTime()) != null) {
            buffer.append("end time: ");
            buffer.append(new Date(endTime));
            buffer.append(lineSeparator);
        }
        if ((cpuTime = info.getCPUTimeSec()) != null) {
            buffer.append("cpu time: ");
            buffer.append(cpuTime);
            buffer.append(" segundos");
            buffer.append(lineSeparator);
        }
        if ((elapsedTime = info.getElapsedTimeSec()) != null) {
            buffer.append("elapsedTime time: ");
            buffer.append(elapsedTime);
            buffer.append(" segundos");
            buffer.append(lineSeparator);
        }
        if ((userTime = info.getUserTimeSec()) != null) {
            buffer.append("elapsedTime time: ");
            buffer.append(userTime);
            buffer.append(" segundos");
            buffer.append(lineSeparator);
        }
        area.setText(buffer.toString());
        area.setColumns(50);
        area.setMinimumSize(area.getPreferredSize());
        this.add((Component)area, "North");
        JButton okButton = new JButton("ok");
        okButton.addActionListener(e -> this.dispose());
        this.add((Component)okButton, "South");
        this.pack();
    }
}

