/*
 * Decompiled with CFR 0.152.
 */
package testealgo;

import csdk.v2.api.application.ApplicationException;
import csdk.v2.api.application.IApplication;
import csdk.v2.api.application.IApplicationContext;
import csdk.v2.api.application.IMessage;
import csdk.v2.api.application.IMessageSender;
import csdk.v2.api.command.CommandException;
import csdk.v2.api.command.IAlgorithmTemplate;
import csdk.v2.api.command.ICommandContext;
import csdk.v2.api.command.ICommandInfo;
import csdk.v2.api.command.ICommandObserver;
import csdk.v2.api.command.IFlowTemplate;
import csdk.v2.api.core.ICSDKEnvironment;
import csdk.v2.api.filesystem.FileSelectionType;
import csdk.v2.api.filesystem.IFile;
import csdk.v2.api.filesystem.local.ILocalFileSystemContext;
import csdk.v2.api.filesystem.project.IProjectContext;
import csdk.v2.helper.ContextNotAvailableException;
import csdk.v2.helper.command.AlgorithmTemplate;
import csdk.v2.helper.command.FlowTemplate;
import csdk.v2.helper.command.TemplateHelper;
import csdk.v2.helper.command.parameters.BooleanParameterValue;
import csdk.v2.helper.command.parameters.DoubleListParameterValue;
import csdk.v2.helper.command.parameters.DoubleParameterValue;
import csdk.v2.helper.command.parameters.EnumerationListParameterValue;
import csdk.v2.helper.command.parameters.EnumerationParameterValue;
import csdk.v2.helper.command.parameters.FileListParameterValue;
import csdk.v2.helper.command.parameters.FileParameterValue;
import csdk.v2.helper.command.parameters.FormulaParameterValue;
import csdk.v2.helper.command.parameters.IParameterValue;
import csdk.v2.helper.command.parameters.IntegerListParameterValue;
import csdk.v2.helper.command.parameters.IntegerParameterValue;
import csdk.v2.helper.command.parameters.ParameterValueConvertionException;
import csdk.v2.helper.command.parameters.RawParameterValue;
import csdk.v2.helper.command.parameters.TableParameterValue;
import csdk.v2.helper.command.parameters.TextListParameterValue;
import csdk.v2.helper.command.parameters.TextParameterValue;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import testealgo.CommandReportFrame;

public class TesteAlgo
implements IApplication {
    private final ICSDKEnvironment csdkInterface;
    private final IApplicationContext appContext;
    private final ICommandContext commandContext;
    private final IProjectContext projectContext;
    private final ILocalFileSystemContext localFileSystemContext;
    private final JFrame mainFrame;

    public TesteAlgo(final ICSDKEnvironment csdkInterface) {
        this.csdkInterface = csdkInterface;
        this.appContext = (IApplicationContext)csdkInterface.getContext(IApplicationContext.class);
        this.commandContext = (ICommandContext)csdkInterface.getContext(ICommandContext.class);
        this.projectContext = (IProjectContext)csdkInterface.getContext(IProjectContext.class);
        this.localFileSystemContext = (ILocalFileSystemContext)csdkInterface.getContext(ILocalFileSystemContext.class);
        this.mainFrame = new JFrame();
        this.mainFrame.setDefaultCloseOperation(0);
        this.mainFrame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                csdkInterface.finishApplication();
            }
        });
    }

    public boolean canEndApplication() {
        int result = JOptionPane.showConfirmDialog(this.mainFrame, this.appContext.getString("confirm.message", new Object[0]), this.appContext.getApplicationName(), 0);
        return result == 0;
    }

    public void onAsyncMessageReceived(IMessage message, IMessageSender sender) {
    }

    public Object onSyncMessageReceived(IMessage message, IMessageSender sender) {
        return null;
    }

    public void onApplicationEnd() throws ApplicationException {
        this.mainFrame.dispose();
    }

    private void initUI() {
        String algoButtonName = this.appContext.getString("execute.algo.button", new Object[0]);
        JButton algoButton = new JButton(algoButtonName);
        algoButton.addActionListener(ev -> {
            try {
                this.executeAlgorithm();
            }
            catch (Exception e) {
                this.csdkInterface.handleException(e, (Window)this.mainFrame);
            }
        });
        algoButton.setEnabled(this.commandContext != null);
        String flowButtonName = this.appContext.getString("execute.flow.button", new Object[0]);
        JButton flowButton = new JButton(flowButtonName);
        flowButton.addActionListener(ev -> {
            try {
                this.executeFlow();
            }
            catch (CommandException e) {
                this.csdkInterface.handleException((Exception)((Object)e), (Window)this.mainFrame);
            }
        });
        flowButton.setEnabled(this.commandContext != null);
        String flowFromFileButtonName = this.appContext.getString("execute.flow.from.file.button", new Object[0]);
        JButton flowFromFileButton = new JButton(flowFromFileButtonName);
        flowFromFileButton.addActionListener(ev -> {
            try {
                this.executeFlowFromFile();
            }
            catch (CommandException e) {
                this.csdkInterface.handleException((Exception)((Object)e), (Window)this.mainFrame);
            }
        });
        flowFromFileButton.setEnabled(this.commandContext != null);
        JPanel panel = new JPanel();
        panel.add(algoButton);
        panel.add(flowButton);
        panel.add(flowFromFileButton);
        this.mainFrame.add(panel);
    }

    public void onApplicationStart() throws ApplicationException {
        this.initUI();
        this.mainFrame.pack();
        this.mainFrame.setVisible(true);
    }

    protected void executeAlgorithm() throws CommandException, ParameterValueConvertionException {
        TemplateHelper helper = new TemplateHelper();
        FileParameterValue fileValue = new FileParameterValue("entrada.txt", "TEXT");
        helper.addParameterValue("ARQUIVO_DE_ENTRADA", (IParameterValue)fileValue);
        FileParameterValue fileValue2 = new FileParameterValue("entrada2.txt", "TEXT");
        FileParameterValue fileValue3 = new FileParameterValue("entrada3.txt", "TEXT");
        FileListParameterValue fileListValue = new FileListParameterValue();
        fileListValue.addValue(fileValue);
        fileListValue.addValue(fileValue2);
        fileListValue.addValue(fileValue3);
        helper.addParameterValue("LISTA_DE_ARQUIVOS_DE_ENTRADA", (IParameterValue)fileListValue);
        FileParameterValue dirValue = new FileParameterValue("dados", "DIR");
        helper.addParameterValue("DIRETORIO_DE_ENTRADA", (IParameterValue)dirValue);
        FileListParameterValue fileDirListValue = new FileListParameterValue();
        fileDirListValue.addValue(fileValue);
        fileDirListValue.addValue(fileValue2);
        fileDirListValue.addValue(dirValue);
        helper.addParameterValue("LISTA_DE_ENTRADAS", (IParameterValue)fileDirListValue);
        helper.addParameterValue("ARQUIVO_DE_SAIDA", (IParameterValue)fileValue);
        helper.addParameterValue("DIRETORIO_DE_SAIDA", (IParameterValue)dirValue);
        helper.addParameterValue("LISTA_DE_ARQUIVOS_DE_SAIDA", (IParameterValue)fileListValue);
        BooleanParameterValue booleanValue = new BooleanParameterValue(Boolean.valueOf(true));
        helper.addParameterValue("BOOLEANO", (IParameterValue)booleanValue);
        IntegerParameterValue integerValue = new IntegerParameterValue(Integer.valueOf(3));
        helper.addParameterValue("INTEIRO", (IParameterValue)integerValue);
        EnumerationParameterValue enumValue = new EnumerationParameterValue("item2");
        helper.addParameterValue("ENUMERACAO", (IParameterValue)enumValue);
        EnumerationListParameterValue enumListValue = new EnumerationListParameterValue();
        enumListValue.addValue((Object)"item1");
        enumListValue.addValue((Object)"item2");
        helper.addParameterValue("ENUMERACAO_MULTIPLA", (IParameterValue)enumListValue);
        FormulaParameterValue formulaValue = new FormulaParameterValue("A + B");
        helper.addParameterValue("FORMULA", (IParameterValue)formulaValue);
        IntegerListParameterValue intListValue = new IntegerListParameterValue(new Integer[]{1, 2, 3});
        helper.addParameterValue("LISTA_DE_INTEIROS", (IParameterValue)intListValue);
        DoubleParameterValue doubleValue = new DoubleParameterValue(Double.valueOf(0.5));
        helper.addParameterValue("REAL", (IParameterValue)doubleValue);
        DoubleListParameterValue doubleListValue = new DoubleListParameterValue(new Double[]{1.5, 2.5, 3.5});
        helper.addParameterValue("LISTA_DE_REAIS", (IParameterValue)doubleListValue);
        TextParameterValue textValue = new TextParameterValue("abc");
        helper.addParameterValue("TEXTO", (IParameterValue)textValue);
        TextListParameterValue textListValue = new TextListParameterValue(new String[]{"aaa", "bbb", "ccc"});
        helper.addParameterValue("LISTA_DE_TEXTO", (IParameterValue)textListValue);
        TableParameterValue tableValue = new TableParameterValue();
        IParameterValue[] row1 = new IParameterValue[]{new DoubleParameterValue(Double.valueOf(1.0)), new BooleanParameterValue(Boolean.valueOf(false)), new IntegerParameterValue(Integer.valueOf(1)), new TextParameterValue("linha1"), new EnumerationParameterValue("item1")};
        IParameterValue[] row2 = new IParameterValue[]{new DoubleParameterValue(Double.valueOf(2.0)), new BooleanParameterValue(Boolean.valueOf(true)), new IntegerParameterValue(Integer.valueOf(2)), new TextParameterValue("linha2"), new EnumerationParameterValue("item2")};
        tableValue.addRow(row1);
        tableValue.addRow(row2);
        helper.addParameterValue("TABELA", (IParameterValue)tableValue);
        RawParameterValue rawValue = new RawParameterValue(this.askForParameterValue());
        helper.addParameterValue("EXIT_CODE", (IParameterValue)rawValue);
        Map parameterValues = helper.generateParameterValuesMap();
        AlgorithmTemplate info = new AlgorithmTemplate("AlgoritmoTesteParametros", "1.0.0", parameterValues);
        this.commandContext.executeAlgorithm((IAlgorithmTemplate)info, "teste CSDK", null, (Window)this.mainFrame, (ICommandObserver)new CommandObserver());
    }

    private String askForParameterValue() {
        String result = JOptionPane.showInputDialog(this.mainFrame, (Object)"C\u00f3digo de sa\u00edda desejado:");
        if (result == null || result.isEmpty()) {
            result = "0";
        }
        return result;
    }

    protected void executeFlow() throws CommandException {
        IFile file;
        HashMap<Integer, AlgorithmTemplate> algosInfo;
        block5: {
            algosInfo = new HashMap<Integer, AlgorithmTemplate>();
            file = null;
            try {
                String[] fileTypes = new String[]{"TEXT"};
                if (this.projectContext != null) {
                    file = this.projectContext.browseProjectFileInOpenMode(fileTypes, true, null, FileSelectionType.FILES_ONLY, (Window)this.mainFrame);
                    break block5;
                }
                if (this.localFileSystemContext != null) {
                    this.localFileSystemContext.browseLocalFileInOpenMode(fileTypes, true, null, FileSelectionType.FILES_ONLY, (Window)this.mainFrame);
                    break block5;
                }
                throw new ContextNotAvailableException(ILocalFileSystemContext.class);
            }
            catch (Exception e) {
                this.csdkInterface.handleException(e, (Window)this.mainFrame);
            }
        }
        if (file == null) {
            return;
        }
        HashMap<String, String> parameterValues1 = new HashMap<String, String>();
        parameterValues1.put("ENTRADA1", file.getStringPath());
        parameterValues1.put("SLEEP", "10");
        AlgorithmTemplate algoInfo1 = new AlgorithmTemplate("AlgoritmoTeste", "1.0.0", parameterValues1);
        algosInfo.put(1, algoInfo1);
        HashMap<String, String> parameterValues2 = new HashMap<String, String>();
        parameterValues2.put("SLEEP", "2");
        AlgorithmTemplate algoInfo2 = new AlgorithmTemplate("AlgoritmoTeste", "1.0.0", parameterValues2);
        algosInfo.put(2, algoInfo2);
        FlowTemplate info = new FlowTemplate("FluxoSimples", "1.0.0", algosInfo);
        this.commandContext.executeFlow((IFlowTemplate)info, "teste fluxo CSDK", null, (Window)this.mainFrame, (ICommandObserver)new CommandObserver());
    }

    protected void executeFlowFromFile() throws CommandException {
        IFile file;
        HashMap<Integer, AlgorithmTemplate> algosInfo;
        block5: {
            algosInfo = new HashMap<Integer, AlgorithmTemplate>();
            file = null;
            try {
                String[] fileTypes = new String[]{"FLX"};
                if (this.projectContext != null) {
                    file = this.projectContext.browseProjectFileInOpenMode(fileTypes, true, null, FileSelectionType.FILES_ONLY, (Window)this.mainFrame);
                    break block5;
                }
                if (this.localFileSystemContext != null) {
                    file = this.localFileSystemContext.browseLocalFileInOpenMode(fileTypes, true, null, FileSelectionType.FILES_ONLY, (Window)this.mainFrame);
                    break block5;
                }
                throw new ContextNotAvailableException(ILocalFileSystemContext.class);
            }
            catch (Exception e) {
                this.csdkInterface.handleException(e, (Window)this.mainFrame);
            }
        }
        if (file == null) {
            return;
        }
        HashMap<String, String> parameterValues1 = new HashMap<String, String>();
        parameterValues1.put("SLEEP", "10");
        AlgorithmTemplate algoInfo1 = new AlgorithmTemplate("AlgoritmoTeste", "1.0.0", parameterValues1);
        algosInfo.put(1, algoInfo1);
        HashMap<String, String> parameterValues2 = new HashMap<String, String>();
        parameterValues2.put("SLEEP", "20");
        AlgorithmTemplate algoInfo2 = new AlgorithmTemplate("AlgoritmoTeste", "1.0.0", parameterValues2);
        algosInfo.put(2, algoInfo2);
        FlowTemplate info = new FlowTemplate(file, algosInfo);
        this.commandContext.executeFlow((IFlowTemplate)info, "teste fluxo com arquivo CSDK", null, (Window)this.mainFrame, (ICommandObserver)new CommandObserver());
    }

    private static final class CommandObserver
    implements ICommandObserver {
        private CommandObserver() {
        }

        public void onCommandEnd(ICommandInfo cmdInfo) {
            SwingUtilities.invokeLater(() -> {
                CommandReportFrame frame = new CommandReportFrame(cmdInfo);
                frame.setVisible(true);
            });
        }
    }
}

