/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.javautils.gui;

import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Locale;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class NumberDocument
extends PlainDocument {
    private String separator;
    private String validateRegex;
    private String insertRegex;

    public NumberDocument() {
        this(Locale.getDefault(), true);
    }

    public NumberDocument(boolean acceptDecimal) {
        this(Locale.getDefault(), acceptDecimal);
    }

    public NumberDocument(Locale locale) {
        this(locale, true);
    }

    public NumberDocument(Locale locale, boolean acceptDecimal) {
        if (acceptDecimal) {
            DecimalFormatSymbols dfs = DecimalFormatSymbols.getInstance(locale);
            this.separator = Character.toString(dfs.getDecimalSeparator());
            this.validateRegex = "([-]{1,1})?[0-9]{1,}([" + this.separator + "][0-9]{1,})?";
            this.insertRegex = "([-]{1,1})?([0-9]{1,})?([" + this.separator + "])?([0-9]{1,})?";
        } else {
            this.validateRegex = "([-]{1,1})?[0-9]{1,}";
            this.insertRegex = "([-]{1,1})?([0-9]{1,})?";
        }
    }

    public Double getValue() {
        try {
            String text = this.getText();
            if (text.matches(this.validateRegex)) {
                NumberFormat n = NumberFormat.getInstance(Locale.getDefault());
                try {
                    return n.parse(text).doubleValue();
                }
                catch (ParseException e) {
                    e.printStackTrace();
                }
            }
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
        return null;
    }

    public void setValue(double value) {
        NumberFormat n = NumberFormat.getInstance(Locale.getDefault());
        String text = n.format(value);
        try {
            this.remove(0, this.getLength());
            this.insertString(0, text, null);
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }

    private String getText() throws BadLocationException {
        return this.getText(0, this.getLength());
    }

    @Override
    public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
        String text = this.getText();
        String newText = text.substring(0, offs) + str + text.substring(offs, text.length());
        if (newText.matches(this.insertRegex)) {
            super.insertString(offs, str, a);
        }
    }
}

