/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.javautils.gui.crud.gui.table;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.SortOrder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import tecgraf.javautils.gui.crud.IRegistrationDescriptor;
import tecgraf.javautils.gui.crud.RegistrationImages;
import tecgraf.javautils.gui.crud.gui.actions.RegistrationAction;
import tecgraf.javautils.gui.crud.gui.main.RegistrationMainPanel;
import tecgraf.javautils.gui.crud.gui.main.RegistrationModeListener;
import tecgraf.javautils.gui.crud.gui.table.RegistrationTableModel;
import tecgraf.javautils.gui.crud.gui.table.RegistrationTableMouseListener;
import tecgraf.javautils.gui.crud.gui.table.RegistrationTableRenderer;
import tecgraf.javautils.gui.table.SortableTable;

public class RegistrationTablePanel<M, I>
extends JPanel {
    private final SortableTable table = new SortableTable();
    private final JScrollPane scrollPane;
    private final IRegistrationDescriptor<M, I> descriptor;
    private final JButton othersButton = new JButton();
    private final RegistrationMainPanel<M, I> mainPanel;

    private final void updateTableColumns() {
        TableColumnModel columnModel = this.table.getColumnModel();
        int numColumns = columnModel.getColumnCount();
        for (int c = 0; c < numColumns; ++c) {
            TableColumn column = columnModel.getColumn(c);
            int width = this.descriptor.getColumnWidth(c);
            column.setPreferredWidth(width);
            column.setWidth(width);
            column.setMinWidth(10);
        }
    }

    public final M getSelectedObject() {
        int row = this.table.getSelectedRow();
        if (row < 0) {
            return null;
        }
        Object object = this.table.getValueAt(row, 0);
        return (M)object;
    }

    private void initTableAttributes() {
        RegistrationTableModel<M, I> model = new RegistrationTableModel<M, I>(this.descriptor);
        this.table.setModel(model);
        RegistrationTableRenderer<M, I> renderer = new RegistrationTableRenderer<M, I>(this.descriptor);
        this.table.setDefaultRenderer(Object.class, renderer);
        this.table.sort(0, SortOrder.ASCENDING);
        this.table.setSelectionMode(0);
        if (model.getRowCount() > 0) {
            this.table.setRowSelectionInterval(0, 0);
        }
        this.table.setAutoResizeMode(4);
    }

    private void updateTableAttributes() {
        RegistrationTableModel<M, I> model = new RegistrationTableModel<M, I>(this.descriptor);
        this.table.setModel(model);
        this.table.sort(0, SortOrder.ASCENDING);
        if (model.getRowCount() > 0) {
            this.table.setRowSelectionInterval(0, 0);
        }
    }

    private JToolBar buildButtonsPanel(JButton othersButton) {
        JToolBar toolbar = new JToolBar(0);
        toolbar.setFloatable(false);
        List<RegistrationAction<M, I>> toolbarActions = this.descriptor.getToolbarActions(this.mainPanel);
        for (RegistrationAction<M, I> registrationAction : toolbarActions) {
            toolbar.add(registrationAction);
        }
        toolbar.add(new JPanel());
        toolbar.add(othersButton);
        return toolbar;
    }

    public RegistrationTablePanel(RegistrationMainPanel<M, I> mainPanel, IRegistrationDescriptor<M, I> descriptor) {
        this.mainPanel = mainPanel;
        this.descriptor = descriptor;
        this.scrollPane = new JScrollPane(this.table);
        this.initOthersButton();
        this.setLayout(new BorderLayout());
        JToolBar buttonsPanel = this.buildButtonsPanel(this.othersButton);
        this.add("Center", this.scrollPane);
        this.add("South", buttonsPanel);
        this.initTableAttributes();
        this.setAddModeListener(mainPanel);
        this.setEditModeListener(mainPanel);
        this.setViewModeListener(mainPanel);
        this.setSelectionListener(mainPanel);
        this.updateTableColumns();
        this.updateTableAttributes();
        RegistrationTableMouseListener<M, I> lst = new RegistrationTableMouseListener<M, I>(this, descriptor);
        this.table.addMouseListener(lst);
        this.setMinimumSize(new Dimension(100, 100));
    }

    private void setSelectionListener(final RegistrationMainPanel<M, I> mainPanel) {
        this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                mainPanel.setMode(RegistrationMainPanel.Mode.VIEW);
                List actions = RegistrationTablePanel.this.descriptor.getOthersMenuActions(mainPanel);
                RegistrationTablePanel.this.othersButton.setEnabled(actions != null && !actions.isEmpty());
            }
        });
    }

    private void setAddModeListener(RegistrationMainPanel<M, I> mainPanel) {
        final RegistrationTablePanel self = this;
        mainPanel.addModeListener(new RegistrationModeListener(){

            @Override
            public void modeChanged(RegistrationMainPanel.Mode oldMode, RegistrationMainPanel.Mode newMode) {
                if (newMode != RegistrationMainPanel.Mode.ADD) {
                    return;
                }
                self.setActive(false);
            }
        });
    }

    private void setEditModeListener(RegistrationMainPanel<M, I> mainPanel) {
        final RegistrationTablePanel self = this;
        mainPanel.addModeListener(new RegistrationModeListener(){

            @Override
            public void modeChanged(RegistrationMainPanel.Mode oldMode, RegistrationMainPanel.Mode newMode) {
                if (newMode != RegistrationMainPanel.Mode.EDIT) {
                    return;
                }
                self.setActive(false);
            }
        });
    }

    private void setViewModeListener(RegistrationMainPanel<M, I> mainPanel) {
        final RegistrationTablePanel self = this;
        mainPanel.addModeListener(new RegistrationModeListener(){

            @Override
            public void modeChanged(RegistrationMainPanel.Mode oldMode, RegistrationMainPanel.Mode newMode) {
                if (newMode != RegistrationMainPanel.Mode.VIEW) {
                    return;
                }
                self.setActive(true);
            }
        });
    }

    private void setActive(boolean flag) {
        this.table.setEnabled(flag);
    }

    private void initOthersButton() {
        this.othersButton.setText(this.mainPanel.getString("button.others"));
        this.othersButton.setIcon(RegistrationImages.ICON_DOWN_4);
        this.othersButton.setHorizontalTextPosition(4);
        this.othersButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RegistrationMainPanel mainPanel = RegistrationTablePanel.this.getMainPanel();
                List actions = RegistrationTablePanel.this.descriptor.getOthersMenuActions(mainPanel);
                if (actions == null || actions.size() == 0) {
                    return;
                }
                JPopupMenu menu = new JPopupMenu();
                for (RegistrationAction action : actions) {
                    menu.add(action);
                }
                int y = RegistrationTablePanel.this.othersButton.getHeight();
                menu.show(RegistrationTablePanel.this.othersButton, 0, y);
            }
        });
    }

    private AbstractTableModel getTableModel() {
        return (AbstractTableModel)this.table.getModel();
    }

    public void updateTable() {
        AbstractTableModel model = this.getTableModel();
        int selectedRow = this.table.getSelectedRow();
        model.fireTableDataChanged();
        if (selectedRow < 0) {
            return;
        }
        int numRows = model.getRowCount();
        if (selectedRow < numRows) {
            this.table.setRowSelectionInterval(selectedRow, selectedRow);
        }
    }

    RegistrationMainPanel<M, I> getMainPanel() {
        return this.mainPanel;
    }

    IRegistrationDescriptor<M, I> getDescriptor() {
        return this.descriptor;
    }
}

