package textviewer.actions;

import javax.swing.Action;

import textviewer.TextViewer;
import textviewer.actions.core.SaveAsAction;
import csdk.v2.api.filesystem.IFile;

/**
 * Ao de gravao do arquivo
 * 
 * @author Tecgraf/PUC-Rio
 */
public class SaveAction extends SaveAsAction {

  /**
   * Construtor
   * 
   * @param textViewer a aplicao
   */
  public SaveAction(TextViewer textViewer) {
    super(textViewer);
    putValue(Action.NAME, textViewer.getString("save.item"));
    putValue(Action.SMALL_ICON, textViewer.getImageIcon(new String[] {
        "actions", "Save16.gif" }));
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected IFile selectFile() throws Exception {
    TextViewer application = getApplication();
    return application.getSelectedFile();
  }
}
