package textviewer.actions;

import java.awt.event.ActionEvent;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;

import javax.swing.Action;
import javax.swing.ImageIcon;

import textviewer.TextViewer;
import csdk.v1_0.helper.application.AbstractApplicationAction;

/**
 * Ao de abertura da ajuda
 * 
 * @author Tecgraf/PUC-Rio
 */
public class HelpAction extends AbstractApplicationAction<TextViewer> {

  /**
   * {@inheritDoc}
   */
  @Override
  public void actionPerformed(ActionEvent ae) {
    TextViewer textViewer = getApplication();
    URL url = textViewer.getResource(new String[] { "help", "help.txt" });
    try {
      if (url != null) {
        @SuppressWarnings("resource")
        InputStream stream = url.openStream();
        textViewer.openStream(stream, textViewer.getCharset());
      }
    }
    catch (IOException e) {
      textViewer.handleException(e, textViewer.getApplicationFrame());
    }
  }

  /**
   * Construtor
   * 
   * @param textViewer a aplicao.
   */
  public HelpAction(TextViewer textViewer) {
    super(textViewer);
    putValue(Action.NAME, textViewer.getString("help.item"));
    ImageIcon icon = textViewer.getSmallApplicationIcon();
    putValue(Action.SMALL_ICON, icon);
  }
}
