/*
 * Decompiled with CFR 0.152.
 */
package csdk.v1_0.helper.application;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;

public class HelperBundle {
    private static final Map<Locale, Properties> bundles = new HashMap<Locale, Properties>();

    public static String getString(Locale locale, Class<?> clazz, String tag) {
        Properties bundle = null;
        if (bundles.containsKey(locale)) {
            bundle = bundles.get(locale);
        } else {
            bundle = HelperBundle.loadBundle(locale);
            if (bundle != null) {
                bundles.put(locale, bundle);
            }
        }
        if (bundle == null) {
            return "<" + tag + ">";
        }
        String key = clazz.getSimpleName() + "." + tag;
        Object value = bundle.get(key);
        if (value == null) {
            return "<<" + tag + ">>";
        }
        return (String)value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties loadBundle(Locale locale) {
        Properties bundle = new Properties();
        String lang = locale.getLanguage();
        String country = locale.getCountry();
        String resourceDir = "resources";
        String fileName = "idiom_" + lang + "_" + country + ".properties";
        String path = resourceDir + "/" + fileName;
        InputStream inStream = HelperBundle.class.getResourceAsStream(path);
        try {
            if (inStream != null) {
                bundle.load(inStream);
                Properties properties = bundle;
                return properties;
            }
            Properties properties = null;
            return properties;
        }
        catch (IOException e) {
            Properties properties = null;
            return properties;
        }
        finally {
            try {
                if (inStream != null) {
                    inStream.close();
                }
            }
            catch (IOException e) {
                return null;
            }
        }
    }
}

