package csdk.v2.extras.context;

import java.util.Date;

import csdk.v2.api.core.IContext;

/**
 * Contexto para acesso aos dados registrados pelo log de eventos.
 *
 * @author Tecgraf
 */
public interface IEventLogContext extends IContext {

  /**
   * Pesquisa a partir das filas e do perodo de tempo quais informaes
   * encontram-se disponveis nos logs de eventos.
   *
   * @param queues filas de armazenamento desejadas
   * @param initialDate data inicial da busca
   * @param finalDate data final da busca
   *
   * @return resultado da busca
   *
   * @throws EventLogException em caso de erro ao buscar os arquivos.
   */
  public ILogsInfo find(final String[][] queues, final Date initialDate,
    final Date finalDate) throws EventLogException;

}