package csdk.v2.extras.context;

import csdk.v2.extras.context.exception.InitializationException;
import tecgraf.openbus.assistant.Assistant;
import tecgraf.openbus.assistant.AssistantParams;
import csdk.v2.api.core.IContext;

/**
 * Contexto de acesso ao OpenBus utilizando as credenciais do usurio logado no
 * cliente do CSBase.
 * 
 * @author Tecgraf
 */
public interface IOpenBusContext extends IContext {

  /**
   * @param params Parmetros para criao do assistente. Para os parmetros que
   *        no forem definidos, sero utilizados parmetros default.
   * @return o assistente de acesso ao barramento do OpenBus j conectado com as
   *         credenciais do usurio.
   * 
   * 
   *         TODO melhorar a descrio do erro.
   * @throws InitializationException erro a ser descrito depois
   */
  public Assistant getAssistant(AssistantParams params)
    throws InitializationException;

}
