/*
 * Decompiled with CFR 0.152.
 */
package ibase.rest.model.algorithm.v1;

import com.fasterxml.jackson.annotation.JsonProperty;
import ibase.rest.model.algorithm.v1.Parameter;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

public class DoubleParameter
extends Parameter {
    private String id = null;
    private String label = null;
    private String description = null;
    private Boolean optional = null;
    private Boolean hidden = null;
    private Boolean ignoreIfHidden = null;
    private Boolean ignoreIfDisabled = null;
    private Object defaultValue = null;
    private Boolean multipleSelection = false;
    private Double minimum = null;
    private Boolean isMinimumIncluded = null;
    private Double maximum = null;
    private Boolean isMaximumIncluded = null;

    @Override
    public DoubleParameter id(String id) {
        this.id = id;
        return this;
    }

    @Override
    @ApiModelProperty(required=true, value="The identification of the parameter.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public DoubleParameter label(String label) {
        this.label = label;
        return this;
    }

    @Override
    @ApiModelProperty(value="The label of the parameter.")
    @JsonProperty(value="label")
    public String getLabel() {
        return this.label;
    }

    @Override
    public void setLabel(String label) {
        this.label = label;
    }

    @Override
    public DoubleParameter description(String description) {
        this.description = description;
        return this;
    }

    @Override
    @ApiModelProperty(value="The parameter description.")
    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public DoubleParameter optional(Boolean optional) {
        this.optional = optional;
        return this;
    }

    @Override
    @ApiModelProperty(value="If the paramenter is not mandatory.")
    @JsonProperty(value="optional")
    public Boolean getOptional() {
        return this.optional;
    }

    @Override
    public void setOptional(Boolean optional) {
        this.optional = optional;
    }

    @Override
    public DoubleParameter hidden(Boolean hidden) {
        this.hidden = hidden;
        return this;
    }

    @Override
    @ApiModelProperty(value="If the paramenter is hidden.")
    @JsonProperty(value="hidden")
    public Boolean getHidden() {
        return this.hidden;
    }

    @Override
    public void setHidden(Boolean hidden) {
        this.hidden = hidden;
    }

    @Override
    public DoubleParameter ignoreIfHidden(Boolean ignoreIfHidden) {
        this.ignoreIfHidden = ignoreIfHidden;
        return this;
    }

    @Override
    @ApiModelProperty(value="If the parameter is hidden, it must not be used as parameter for the algorithm execution.")
    @JsonProperty(value="ignore_if_hidden")
    public Boolean getIgnoreIfHidden() {
        return this.ignoreIfHidden;
    }

    @Override
    public void setIgnoreIfHidden(Boolean ignoreIfHidden) {
        this.ignoreIfHidden = ignoreIfHidden;
    }

    @Override
    public DoubleParameter ignoreIfDisabled(Boolean ignoreIfDisabled) {
        this.ignoreIfDisabled = ignoreIfDisabled;
        return this;
    }

    @Override
    @ApiModelProperty(value="If the parameter is disabled, it must not be used as parameter for the algorithm execution.")
    @JsonProperty(value="ignore_if_disabled")
    public Boolean getIgnoreIfDisabled() {
        return this.ignoreIfDisabled;
    }

    @Override
    public void setIgnoreIfDisabled(Boolean ignoreIfDisabled) {
        this.ignoreIfDisabled = ignoreIfDisabled;
    }

    @Override
    public DoubleParameter defaultValue(Object defaultValue) {
        this.defaultValue = defaultValue;
        return this;
    }

    @Override
    @ApiModelProperty(value="A json object that is the default value for this parameter. It depends of the parameter type.")
    @JsonProperty(value="default_value")
    public Object getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public void setDefaultValue(Object defaultValue) {
        this.defaultValue = defaultValue;
    }

    public DoubleParameter multipleSelection(Boolean multipleSelection) {
        this.multipleSelection = multipleSelection;
        return this;
    }

    @ApiModelProperty(value="If this parameter allows multiple selection.")
    @JsonProperty(value="multiple_selection")
    public Boolean getMultipleSelection() {
        return this.multipleSelection;
    }

    public void setMultipleSelection(Boolean multipleSelection) {
        this.multipleSelection = multipleSelection;
    }

    public DoubleParameter minimum(Double minimum) {
        this.minimum = minimum;
        return this;
    }

    @ApiModelProperty(value="The minimum value allowed for this parameter value.")
    @JsonProperty(value="minimum")
    public Double getMinimum() {
        return this.minimum;
    }

    public void setMinimum(Double minimum) {
        this.minimum = minimum;
    }

    public DoubleParameter isMinimumIncluded(Boolean isMinimumIncluded) {
        this.isMinimumIncluded = isMinimumIncluded;
        return this;
    }

    @ApiModelProperty(value="If the mimimum value is allowed.")
    @JsonProperty(value="is_minimum_included")
    public Boolean getIsMinimumIncluded() {
        return this.isMinimumIncluded;
    }

    public void setIsMinimumIncluded(Boolean isMinimumIncluded) {
        this.isMinimumIncluded = isMinimumIncluded;
    }

    public DoubleParameter maximum(Double maximum) {
        this.maximum = maximum;
        return this;
    }

    @ApiModelProperty(value="The maximum value allowed for this parameter value.")
    @JsonProperty(value="maximum")
    public Double getMaximum() {
        return this.maximum;
    }

    public void setMaximum(Double maximum) {
        this.maximum = maximum;
    }

    public DoubleParameter isMaximumIncluded(Boolean isMaximumIncluded) {
        this.isMaximumIncluded = isMaximumIncluded;
        return this;
    }

    @ApiModelProperty(value="If the maximum value is allowed.")
    @JsonProperty(value="is_maximum_included")
    public Boolean getIsMaximumIncluded() {
        return this.isMaximumIncluded;
    }

    public void setIsMaximumIncluded(Boolean isMaximumIncluded) {
        this.isMaximumIncluded = isMaximumIncluded;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DoubleParameter doubleParameter = (DoubleParameter)o;
        return Objects.equals(this.id, doubleParameter.id) && Objects.equals(this.label, doubleParameter.label) && Objects.equals(this.description, doubleParameter.description) && Objects.equals(this.optional, doubleParameter.optional) && Objects.equals(this.hidden, doubleParameter.hidden) && Objects.equals(this.ignoreIfHidden, doubleParameter.ignoreIfHidden) && Objects.equals(this.ignoreIfDisabled, doubleParameter.ignoreIfDisabled) && Objects.equals(this.defaultValue, doubleParameter.defaultValue) && Objects.equals(this.multipleSelection, doubleParameter.multipleSelection) && Objects.equals(this.minimum, doubleParameter.minimum) && Objects.equals(this.isMinimumIncluded, doubleParameter.isMinimumIncluded) && Objects.equals(this.maximum, doubleParameter.maximum) && Objects.equals(this.isMaximumIncluded, doubleParameter.isMaximumIncluded);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.id, this.label, this.description, this.optional, this.hidden, this.ignoreIfHidden, this.ignoreIfDisabled, this.defaultValue, this.multipleSelection, this.minimum, this.isMinimumIncluded, this.maximum, this.isMaximumIncluded);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DoubleParameter {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    label: ").append(this.toIndentedString(this.label)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    optional: ").append(this.toIndentedString(this.optional)).append("\n");
        sb.append("    hidden: ").append(this.toIndentedString(this.hidden)).append("\n");
        sb.append("    ignoreIfHidden: ").append(this.toIndentedString(this.ignoreIfHidden)).append("\n");
        sb.append("    ignoreIfDisabled: ").append(this.toIndentedString(this.ignoreIfDisabled)).append("\n");
        sb.append("    defaultValue: ").append(this.toIndentedString(this.defaultValue)).append("\n");
        sb.append("    multipleSelection: ").append(this.toIndentedString(this.multipleSelection)).append("\n");
        sb.append("    minimum: ").append(this.toIndentedString(this.minimum)).append("\n");
        sb.append("    isMinimumIncluded: ").append(this.toIndentedString(this.isMinimumIncluded)).append("\n");
        sb.append("    maximum: ").append(this.toIndentedString(this.maximum)).append("\n");
        sb.append("    isMaximumIncluded: ").append(this.toIndentedString(this.isMaximumIncluded)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

