/*
 * Decompiled with CFR 0.152.
 */
package ibase.rest.model.algorithm.v1;

import com.fasterxml.jackson.annotation.JsonProperty;
import ibase.rest.model.algorithm.v1.Parameter;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

public class IntegerParameter
extends Parameter {
    private String id = null;
    private String label = null;
    private String description = null;
    private Boolean optional = null;
    private Boolean hidden = null;
    private Boolean ignoreIfHidden = null;
    private Boolean ignoreIfDisabled = null;
    private Object defaultValue = null;
    private Boolean multipleSelection = false;
    private Integer minimum = null;
    private Integer maximum = null;

    @Override
    public IntegerParameter id(String id) {
        this.id = id;
        return this;
    }

    @Override
    @ApiModelProperty(required=true, value="The identification of the parameter.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public IntegerParameter label(String label) {
        this.label = label;
        return this;
    }

    @Override
    @ApiModelProperty(value="The label of the parameter.")
    @JsonProperty(value="label")
    public String getLabel() {
        return this.label;
    }

    @Override
    public void setLabel(String label) {
        this.label = label;
    }

    @Override
    public IntegerParameter description(String description) {
        this.description = description;
        return this;
    }

    @Override
    @ApiModelProperty(value="The parameter description.")
    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public IntegerParameter optional(Boolean optional) {
        this.optional = optional;
        return this;
    }

    @Override
    @ApiModelProperty(value="If the paramenter is not mandatory.")
    @JsonProperty(value="optional")
    public Boolean getOptional() {
        return this.optional;
    }

    @Override
    public void setOptional(Boolean optional) {
        this.optional = optional;
    }

    @Override
    public IntegerParameter hidden(Boolean hidden) {
        this.hidden = hidden;
        return this;
    }

    @Override
    @ApiModelProperty(value="If the paramenter is hidden.")
    @JsonProperty(value="hidden")
    public Boolean getHidden() {
        return this.hidden;
    }

    @Override
    public void setHidden(Boolean hidden) {
        this.hidden = hidden;
    }

    @Override
    public IntegerParameter ignoreIfHidden(Boolean ignoreIfHidden) {
        this.ignoreIfHidden = ignoreIfHidden;
        return this;
    }

    @Override
    @ApiModelProperty(value="If the parameter is hidden, it must not be used as parameter for the algorithm execution.")
    @JsonProperty(value="ignore_if_hidden")
    public Boolean getIgnoreIfHidden() {
        return this.ignoreIfHidden;
    }

    @Override
    public void setIgnoreIfHidden(Boolean ignoreIfHidden) {
        this.ignoreIfHidden = ignoreIfHidden;
    }

    @Override
    public IntegerParameter ignoreIfDisabled(Boolean ignoreIfDisabled) {
        this.ignoreIfDisabled = ignoreIfDisabled;
        return this;
    }

    @Override
    @ApiModelProperty(value="If the parameter is disabled, it must not be used as parameter for the algorithm execution.")
    @JsonProperty(value="ignore_if_disabled")
    public Boolean getIgnoreIfDisabled() {
        return this.ignoreIfDisabled;
    }

    @Override
    public void setIgnoreIfDisabled(Boolean ignoreIfDisabled) {
        this.ignoreIfDisabled = ignoreIfDisabled;
    }

    @Override
    public IntegerParameter defaultValue(Object defaultValue) {
        this.defaultValue = defaultValue;
        return this;
    }

    @Override
    @ApiModelProperty(value="A json object that is the default value for this parameter. It depends of the parameter type.")
    @JsonProperty(value="default_value")
    public Object getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public void setDefaultValue(Object defaultValue) {
        this.defaultValue = defaultValue;
    }

    public IntegerParameter multipleSelection(Boolean multipleSelection) {
        this.multipleSelection = multipleSelection;
        return this;
    }

    @ApiModelProperty(value="If this parameter allows multiple selection.")
    @JsonProperty(value="multiple_selection")
    public Boolean getMultipleSelection() {
        return this.multipleSelection;
    }

    public void setMultipleSelection(Boolean multipleSelection) {
        this.multipleSelection = multipleSelection;
    }

    public IntegerParameter minimum(Integer minimum) {
        this.minimum = minimum;
        return this;
    }

    @ApiModelProperty(value="The minimum value allowed for this parameter value.")
    @JsonProperty(value="minimum")
    public Integer getMinimum() {
        return this.minimum;
    }

    public void setMinimum(Integer minimum) {
        this.minimum = minimum;
    }

    public IntegerParameter maximum(Integer maximum) {
        this.maximum = maximum;
        return this;
    }

    @ApiModelProperty(value="The maximum value allowed for this parameter value.")
    @JsonProperty(value="maximum")
    public Integer getMaximum() {
        return this.maximum;
    }

    public void setMaximum(Integer maximum) {
        this.maximum = maximum;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IntegerParameter integerParameter = (IntegerParameter)o;
        return Objects.equals(this.id, integerParameter.id) && Objects.equals(this.label, integerParameter.label) && Objects.equals(this.description, integerParameter.description) && Objects.equals(this.optional, integerParameter.optional) && Objects.equals(this.hidden, integerParameter.hidden) && Objects.equals(this.ignoreIfHidden, integerParameter.ignoreIfHidden) && Objects.equals(this.ignoreIfDisabled, integerParameter.ignoreIfDisabled) && Objects.equals(this.defaultValue, integerParameter.defaultValue) && Objects.equals(this.multipleSelection, integerParameter.multipleSelection) && Objects.equals(this.minimum, integerParameter.minimum) && Objects.equals(this.maximum, integerParameter.maximum);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.id, this.label, this.description, this.optional, this.hidden, this.ignoreIfHidden, this.ignoreIfDisabled, this.defaultValue, this.multipleSelection, this.minimum, this.maximum);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class IntegerParameter {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    label: ").append(this.toIndentedString(this.label)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    optional: ").append(this.toIndentedString(this.optional)).append("\n");
        sb.append("    hidden: ").append(this.toIndentedString(this.hidden)).append("\n");
        sb.append("    ignoreIfHidden: ").append(this.toIndentedString(this.ignoreIfHidden)).append("\n");
        sb.append("    ignoreIfDisabled: ").append(this.toIndentedString(this.ignoreIfDisabled)).append("\n");
        sb.append("    defaultValue: ").append(this.toIndentedString(this.defaultValue)).append("\n");
        sb.append("    multipleSelection: ").append(this.toIndentedString(this.multipleSelection)).append("\n");
        sb.append("    minimum: ").append(this.toIndentedString(this.minimum)).append("\n");
        sb.append("    maximum: ").append(this.toIndentedString(this.maximum)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

