/*
 * Decompiled with CFR 0.152.
 */
package ibase.rest.adapter.execution_node.v1;

import csbase.logic.SGASet;
import csbase.logic.algorithms.AlgorithmConfigurator;
import csbase.logic.algorithms.AlgorithmVersionId;
import csbase.remote.AlgorithmServiceInterface;
import csbase.remote.ClientRemoteLocator;
import csbase.remote.SGAServiceInterface;
import ibase.rest.adapter.execution_node.v1.FilterByJsonRequirements;
import ibase.rest.api.execution_node.v1.adapter.ExecutionNodeServiceAdapter;
import ibase.rest.model.execution_node.v1.ExecutionNode;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.Vector;
import java.util.stream.Collectors;

public class CSBaseExecutionNodeServiceAdapter
implements ExecutionNodeServiceAdapter {
    public void setLocale(Locale locale) {
        ClientRemoteLocator.administrationService.setLocale(locale);
    }

    public List<ExecutionNode> getExecutionResources(String algorithmId, String versionId, List<String> selectedPlataforms) {
        SGAServiceInterface sgaService = ClientRemoteLocator.sgaService;
        AlgorithmServiceInterface algorithmService = ClientRemoteLocator.algorithmService;
        ArrayList<ExecutionNode> executionNodes = new ArrayList<ExecutionNode>();
        try {
            Set requirements = new HashSet();
            if (algorithmId != null && versionId != null && !versionId.isEmpty() && !algorithmId.isEmpty()) {
                AlgorithmVersionId algoVersionId = AlgorithmVersionId.create((String)versionId);
                AlgorithmConfigurator configurator = algorithmService.createAlgorithmConfigurator(algorithmId, algoVersionId);
                requirements = configurator.getRequirements();
                if (selectedPlataforms == null || selectedPlataforms.isEmpty()) {
                    selectedPlataforms = configurator.getPlatforms().stream().collect(Collectors.toList());
                }
            }
            Vector sgaNames = sgaService.getAllSGANames();
            for (String sgaName : sgaNames) {
                SGASet sga = sgaService.getSGASet(sgaName);
                if (sga == null || selectedPlataforms != null && !selectedPlataforms.isEmpty() && !sga.isPlatformSupported(selectedPlataforms) || requirements != null && !requirements.isEmpty() && !sga.hasRequirements(requirements) || !sga.mayExecuteCommand()) continue;
                ExecutionNode node = this.buildExecutionNode(sga);
                executionNodes.add(node);
            }
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        return executionNodes;
    }

    public List<ExecutionNode> getExecutionResources(String requirements) {
        ArrayList<ExecutionNode> resources = new ArrayList<ExecutionNode>();
        SGAServiceInterface sgaService = ClientRemoteLocator.sgaService;
        try {
            Vector sgaNames = sgaService.getAllSGANames();
            List<SGASet> sgas = new ArrayList<SGASet>();
            for (String sgaName : sgaNames) {
                SGASet sga2 = sgaService.getSGASet(sgaName);
                if (!sga2.mayExecuteCommand()) continue;
                sgas.add(sga2);
            }
            FilterByJsonRequirements filter = new FilterByJsonRequirements(requirements);
            sgas = filter.filter(sgas);
            sgas.stream().forEach(sga -> resources.add(this.buildExecutionNode((SGASet)sga)));
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        return resources;
    }

    private ExecutionNode buildExecutionNode(SGASet sga) {
        ExecutionNode node = new ExecutionNode();
        node.setName(sga.getName());
        node.setPlatform(sga.getPlatformId());
        return node;
    }
}

