/*
 * Decompiled with CFR 0.152.
 */
package ibase.common;

import ibase.common.DAOFactory;
import ibase.common.ServiceUtil;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.utilities.ServiceLocatorUtilities;

public interface ServiceAdapter {
    public static final Map<Class<?>, DAOFactory> DAOFactories = new HashMap();
    public static final ThreadLocal<ServiceLocator> serviceLocatorThreadLocal = new ThreadLocal();
    public static final ThreadLocal<String> authenticationThreadLocal = new ThreadLocal();
    public static final ThreadLocal<String> uriThreadLocal = new ThreadLocal();
    public static final ThreadLocal<String> userThreadLocal = new ThreadLocal();
    public static final ThreadLocal<Properties> propertiesThreadLocal = new ThreadLocal();

    public void setLocale(Locale var1);

    public static String getCurrenUser() {
        return userThreadLocal.get();
    }

    public static void setCurrentUser(String userId) {
        userThreadLocal.set(userId);
    }

    public static void addProperty(String key, String value) {
        Properties p = propertiesThreadLocal.get();
        if (p == null) {
            p = new Properties();
            propertiesThreadLocal.set(p);
        }
        p.setProperty(key, value);
    }

    public static String getProperty(String key) {
        Properties p = propertiesThreadLocal.get();
        if (p == null) {
            return null;
        }
        return p.getProperty(key);
    }

    public static <T extends ServiceAdapter> T getInstance(Class<T> serviceClass, String localeString) {
        ServiceAdapter service = (ServiceAdapter)ServiceLocatorUtilities.findOrCreateService((ServiceLocator)serviceLocatorThreadLocal.get(), serviceClass, (Annotation[])new Annotation[0]);
        Locale locale = ServiceUtil.getLocale(localeString);
        service.setLocale(locale);
        return (T)service;
    }

    public static void setServiceLocator(ServiceLocator serviceLocator) {
        serviceLocatorThreadLocal.set(serviceLocator);
    }

    public static String getAutheticationHeader() {
        return authenticationThreadLocal.get();
    }

    public static void setAuthorizationHeader(String authorizationHeader) {
        authenticationThreadLocal.set(authorizationHeader);
    }

    public static String getURI() {
        return uriThreadLocal.get();
    }

    public static void setURI(String baseUri) {
        uriThreadLocal.set(baseUri);
    }

    public static void clean() {
        ServiceAdapter.setServiceLocator(null);
    }

    public static void addDAOFactory(Class<?> DAOClass, DAOFactory factory) {
        DAOFactories.put(DAOClass, factory);
    }

    public static <T> T getDAOFactory(Class<T> DAOClass) {
        return (T)DAOFactories.get(DAOClass);
    }
}

