/*
 * Decompiled with CFR 0.152.
 */
package ibase.rest.api.application.v2;

import ibase.rest.api.application.v2.ApplicationsApiService;
import ibase.rest.api.application.v2.NotFoundException;
import ibase.rest.api.application.v2.factories.ApplicationsApiServiceFactory;
import ibase.rest.model.application.v2.Application;
import ibase.rest.model.application.v2.InlineResponse200;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;

@Path(value="/applications")
@Produces(value={"application/json"})
@Api(description="the applications API")
public class ApplicationsApi {
    private final ApplicationsApiService delegate = ApplicationsApiServiceFactory.getApplicationsApi();

    @GET
    @Path(value="/{applicationId}/documentation/download/")
    @Produces(value={"application/json"})
    @ApiOperation(value="Download a application version documentation file", notes="This endpoint returns the documentation file of a application version.", response=void.class, tags={"Applications"})
    @ApiResponses(value={@ApiResponse(code=200, message="The specified application's binary", response=void.class), @ApiResponse(code=400, message="If the fileName parameter does not exist", response=void.class), @ApiResponse(code=404, message="if not found the specified applicationId", response=void.class)})
    public Response applicationsApplicationIdDocumentationDownloadGet(@ApiParam(value="The ID of an application.", required=true) @PathParam(value="applicationId") String applicationId, @ApiParam(value="The name of the file to be downloaded from the application version documentation.", required=true) @QueryParam(value="fileName") String fileName, @ApiParam(value="The locale adopted for internationalization. When provided, this locale defines the language for message responses.") @QueryParam(value="locale") String locale, @Context SecurityContext securityContext) throws NotFoundException {
        return this.delegate.applicationsApplicationIdDocumentationDownloadGet(applicationId, fileName, locale, securityContext);
    }

    @GET
    @Path(value="/{applicationId}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Find an application by its ID", notes="This endpoint returns an application by its ID. The ID is encoded in Base64.", response=Application.class, tags={"Applications"})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful operation", response=Application.class), @ApiResponse(code=404, message="application not found.", response=Application.class)})
    public Response applicationsApplicationIdGet(@ApiParam(value="The ID of an application.", required=true) @PathParam(value="applicationId") String applicationId, @ApiParam(value="The locale adopted for internationalization. When provided, this locale defines the language for message responses.") @QueryParam(value="locale") String locale, @Context SecurityContext securityContext) throws NotFoundException {
        return this.delegate.applicationsApplicationIdGet(applicationId, locale, securityContext);
    }

    @GET
    @Path(value="/documentation/")
    @Produces(value={"application/json"})
    @ApiOperation(value="Download all application documentation files", notes="This endpoint returns the documentation of all applications as a json file.", response=InlineResponse200.class, responseContainer="List", tags={"Applications"})
    @ApiResponses(value={@ApiResponse(code=200, message="The documentation of all applications", response=InlineResponse200.class, responseContainer="List"), @ApiResponse(code=404, message="if not found the applications documentation", response=InlineResponse200.class, responseContainer="List")})
    public Response applicationsDocumentationGet(@ApiParam(value="The locale adopted for internationalization. When provided, this locale defines the language for message responses.") @QueryParam(value="locale") String locale, @Context SecurityContext securityContext) throws NotFoundException {
        return this.delegate.applicationsDocumentationGet(locale, securityContext);
    }

    @GET
    @Produces(value={"application/json"})
    @ApiOperation(value="List the available applications.", notes="This endpoint returns information about the applications available for submission on execution environments. The response includes the application name and other details about each application. ", response=Application.class, responseContainer="List", tags={"Applications"})
    @ApiResponses(value={@ApiResponse(code=200, message="An array of applications", response=Application.class, responseContainer="List"), @ApiResponse(code=200, message="Unexpected error", response=Application.class, responseContainer="List")})
    public Response applicationsGet(@ApiParam(value="Filter the applications by the begining of the name provided. Only the applications which name begins with the filter name will be returned. This filter is not case sensitive. If this filter is not provided, the response list all the applications available.") @QueryParam(value="name") String name, @ApiParam(value="The locale adopted for internationalization. When provided, this locale defines the language for message responses.") @QueryParam(value="locale") String locale, @Context SecurityContext securityContext) throws NotFoundException {
        return this.delegate.applicationsGet(name, locale, securityContext);
    }
}

