/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.javautils.concurrent.locks;

import tecgraf.javautils.concurrent.locks.LockId;
import tecgraf.javautils.concurrent.locks.LockInfo;

public enum LockPolicy {
    EXCLUSIVE(3){

        @Override
        boolean allowsLock(LockInfo lockInfo, Object ownerKey, LockId originatorLockId) {
            return lockInfo.getLocks(originatorLockId, this.getIncompatibleLockPolicies()).size() <= 0 || lockInfo.allowsReentrance() && lockInfo.getLocks(originatorLockId, PROTECTED_WRITE, PROTECTED_READ, CONCURRENT_READ).size() <= 0 && lockInfo.getLocks(ownerKey, EXCLUSIVE).size() == lockInfo.getLocks(EXCLUSIVE).size();
        }

        @Override
        public LockPolicy[] getIncompatibleLockPolicies() {
            return new LockPolicy[]{EXCLUSIVE, PROTECTED_WRITE, PROTECTED_READ, CONCURRENT_READ};
        }
    }
    ,
    PROTECTED_WRITE(2){

        @Override
        boolean allowsLock(LockInfo lockInfo, Object ownerKey, LockId originatorLockId) {
            return lockInfo.getLocks(originatorLockId, this.getIncompatibleLockPolicies()).size() <= 0 || lockInfo.allowsReentrance() && lockInfo.getLocks(originatorLockId, PROTECTED_READ).size() <= 0 && lockInfo.getLocks(ownerKey, PROTECTED_WRITE, EXCLUSIVE).size() == lockInfo.getLocks(PROTECTED_WRITE, EXCLUSIVE).size();
        }

        @Override
        public LockPolicy[] getIncompatibleLockPolicies() {
            return new LockPolicy[]{EXCLUSIVE, PROTECTED_WRITE, PROTECTED_READ};
        }
    }
    ,
    PROTECTED_READ(1){

        @Override
        boolean allowsLock(LockInfo lockInfo, Object ownerKey, LockId originatorLockId) {
            return lockInfo.getLocks(originatorLockId, this.getIncompatibleLockPolicies()).size() <= 0 || lockInfo.allowsReentrance() && lockInfo.getLocks(ownerKey, PROTECTED_WRITE, EXCLUSIVE).size() == lockInfo.getLocks(PROTECTED_WRITE, EXCLUSIVE).size();
        }

        @Override
        public LockPolicy[] getIncompatibleLockPolicies() {
            return new LockPolicy[]{EXCLUSIVE, PROTECTED_WRITE};
        }
    }
    ,
    CONCURRENT_READ(0){

        @Override
        boolean allowsLock(LockInfo lockInfo, Object ownerKey, LockId originatorLockId) {
            return lockInfo.getLocks(originatorLockId, this.getIncompatibleLockPolicies()).size() <= 0 || lockInfo.allowsReentrance() && lockInfo.getLocks(ownerKey, EXCLUSIVE).size() == lockInfo.getLocks(EXCLUSIVE).size();
        }

        @Override
        public LockPolicy[] getIncompatibleLockPolicies() {
            return new LockPolicy[]{EXCLUSIVE};
        }
    };

    private int value;

    private LockPolicy(int value) {
        this.value = value;
    }

    int getValue() {
        return this.value;
    }

    abstract boolean allowsLock(LockInfo var1, Object var2, LockId var3);

    public abstract LockPolicy[] getIncompatibleLockPolicies();
}

