/*
 * Detalhes da ltima alterao:
 * 
 * $Author: rodrigoh $ $Date: 2006-02-14 16:43:23 -0200 (Tue, 14 Feb 2006) $
 * $Revision: 2023 $
 */
package tecgraf.javautils.configurationmanager;

import java.text.MessageFormat;

/**
 * Representa uma exceo gerada pelo gerenciador de configuraes.
 * 
 * @author Tecgraf/PUC-Rio
 */
public class ConfigurationManagerException extends Exception {

  /**
   * Cria a exceo com a mensagem dada.
   * 
   * @param message mensagem de erro.
   */
  public ConfigurationManagerException(String message) {
    super(message);
  }

  /**
   * Cria a exceo com a mensagem dada pela aplicao dos argumentos ao padro.
   * 
   * @param pattern padro com a descrio do erro.
   * @param arguments argumentos que sero formatados na descrio do erro.
   * 
   * @see MessageFormat
   */
  public ConfigurationManagerException(String pattern, Object... arguments) {
    super(MessageFormat.format(pattern, arguments));
  }

  /**
   * Cria a exceo com a mensagem dada pela aplicao dos argumentos ao padro
   * e com a causa da exceo.
   * 
   * @param exception exceo original.
   * @param pattern padro com a descrio do erro.
   * @param arguments argumentos que sero formatados na descrio do erro.
   * 
   * @see MessageFormat
   */
  public ConfigurationManagerException(Throwable exception, String pattern,
    Object... arguments) {
    super(MessageFormat.format(pattern, arguments), exception);
  }
}
