package tecgraf.javautils.configurationmanager;

/**
 * Representa uma exceo gerada quando uma propriedade obrigatria de uma
 * configurao no est definida. A mensagem desta exceo est sempre no
 * idioma Portugus do Brasil. Para gerar mensagens traduzidas para outro
 * idioma, deve-se usar os mtodos {@link #getOwnerClass()} e
 * {@link #getPropertyName()} e, com estes dados, compor a mensagem.
 * 
 * @author Tecgraf/PUC-Rio
 */
public class MissingPropertyException extends ConfigurationManagerException {

  /** Mensagem da exceo. */
  private static final String MESSAGE =
    "A propriedade {0} no est presente na classe {1}.";

  /** A classe que requisitou a propriedade. */
  private Class<?> ownerClass;

  /** O nome da propriedade requisitada. */
  private String propertyName;

  /**
   * Construtor.
   * 
   * @param ownerClass classe que requisitou a propriedade.
   * @param propertyName nome da propriedade requisitada.
   */
  MissingPropertyException(Class<?> ownerClass, String propertyName) {
    super(MESSAGE, propertyName, ownerClass);
    this.ownerClass = ownerClass;
    this.propertyName = propertyName;
  }

  /**
   * Classe que requisitou a propriedade.
   * 
   * @return classe que requisitou a propriedade.
   */
  public Class<?> getOwnerClass() {
    return ownerClass;
  }

  /**
   * Nome da propriedade requisitada.
   * 
   * @return nome da propriedade requisitada.
   */
  public String getPropertyName() {
    return propertyName;
  }
}
