/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.javautils.gui.print;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.image.ImageObserver;
import java.awt.print.PageFormat;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.util.BitSet;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.table.TableModel;
import tecgraf.javautils.core.lng.LNG;
import tecgraf.javautils.gui.print.DefaultPrintableTableModel;
import tecgraf.javautils.gui.print.PrintConfiguration;
import tecgraf.javautils.gui.print.PrintableTable;
import tecgraf.javautils.gui.print.PrintableTableModel;
import tecgraf.javautils.gui.print.TableColumnGroup;
import tecgraf.javautils.gui.print.TextTool;
import tecgraf.javautils.gui.table.Colored;
import tecgraf.javautils.gui.table.FooterCell;

public class DefaultPrintableTable
implements PrintableTable,
ImageObserver {
    private static final String trueString = LNG.get((String)"javautils.yes");
    private static final String falseString = LNG.get((String)"javautils.no");
    private DefaultPrintableTableModel model;
    private Font defaultFont;
    private CellInfo[][] cellInfo;
    private float[] rowHeight;
    private float[] columnWeight;
    private List<TableColumnGroup> columnGroups;
    private int columnCount;
    private float[] columnSize;
    private float lineWidth;
    private boolean drawLines;
    private float horizontalInset;
    private float verticalInset;
    private String posText;
    private Font posTextFont;
    private Font modifiedPosTextFont;
    private String header;
    private Font headerFont;
    private Font modifiedHeaderFont;
    private String title;
    private Font titleFont;
    private Font modifiedTitleFont;
    private DateFormat dateFormat;
    private NumberFormat decimalFormat;
    private boolean printing;
    private boolean simulating;
    private int firstPage;
    private int lastPage;
    private int titlePage;
    private int nextRow;
    private int lastRow;
    private int nextCol;
    private int lastCol;
    private int lastPageNumRows;
    private int verticalPagesCount;
    private float height;
    private float width;
    private TextTool textTool;
    private boolean breakTable;
    private boolean adjustWidth;
    private float tableWidth;
    private int alignment;
    private float xInset;
    private BitSet lineBorderInvisible;
    private BitSet columnBorderInvisible;
    private BitSet[] joinColumns;
    private boolean alignTableHeader;
    private String lineWrap = "none";
    private PrintConfiguration configuration;
    private boolean changeCellFont;
    private boolean changeTextFont;
    private boolean imageRenderingDone;
    private Map<Integer, Integer> columnAlignments;
    private Color[][] cellBackground;
    private float lastY;

    public DefaultPrintableTable(TableModel model) {
        this(model, new Font("SansSerif", 0, 10));
    }

    public DefaultPrintableTable(TableModel model, Font font) {
        this(new DefaultPrintableTableModel(model), font, true);
    }

    public DefaultPrintableTable(TableModel model, Font font, boolean changeCellFont) {
        this(new DefaultPrintableTableModel(model), font, changeCellFont);
    }

    public DefaultPrintableTable(TableModel model, Font font, boolean changeCellFont, boolean changeTextFont) {
        this(new DefaultPrintableTableModel(model), font, changeCellFont, changeTextFont, null);
    }

    public DefaultPrintableTable(TableModel model, Font font, boolean changeCellFont, boolean changeTextFont, List<TableColumnGroup> columnGroups) {
        this(new DefaultPrintableTableModel(model), font, changeCellFont, changeTextFont, columnGroups);
    }

    public DefaultPrintableTable(PrintableTableModel model) {
        this(model, new Font("SansSerif", 0, 10));
    }

    public DefaultPrintableTable(DefaultPrintableTableModel model, Font font, boolean changeCellFont) {
        this(model, font, changeCellFont, true, null);
    }

    public DefaultPrintableTable(DefaultPrintableTableModel model, Font font, boolean changeCellFont, boolean changeTextFont, List<TableColumnGroup> columnGroups) {
        if (model == null) {
            throw new IllegalArgumentException("O modelo n\u00e3o pode ser null.");
        }
        this.model = model;
        this.setInsets(1.0f, 1.0f);
        this.setLineWidth(0.1f);
        this.defaultFont = font;
        this.changeCellFont = changeCellFont;
        this.changeTextFont = changeTextFont;
        this.columnGroups = columnGroups;
        if (this.columnGroups != null && this.columnGroups.isEmpty()) {
            this.columnGroups = null;
        }
        boolean hasRowNames = model.hasRowNames();
        boolean hasColumnGroups = this.columnGroups != null;
        int rowCount = model.getRowCount() + (hasColumnGroups ? 2 : 1);
        this.columnCount = model.getColumnCount() + (hasRowNames ? 1 : 0);
        this.cellInfo = new CellInfo[rowCount][this.columnCount];
        this.cellBackground = new Color[rowCount][this.columnCount];
        this.rowHeight = new float[rowCount];
        this.columnSize = new float[model.getColumnCount() + (hasRowNames ? 1 : 0)];
        this.dateFormat = DateFormat.getDateInstance();
        this.decimalFormat = NumberFormat.getInstance(LNG.getLocale());
        this.textTool = new TextTool();
        this.printing = false;
        this.simulating = false;
        this.alignment = 0;
        this.columnAlignments = new HashMap<Integer, Integer>();
        this.xInset = 0.0f;
        this.adjustWidth = true;
        this.alignTableHeader = false;
        this.lineBorderInvisible = new BitSet();
        this.columnBorderInvisible = new BitSet();
        this.joinColumns = new BitSet[rowCount];
        for (int row = 0; row < this.joinColumns.length; ++row) {
            this.joinColumns[row] = new BitSet();
        }
        this.initPrinting(new PrintConfiguration());
    }

    private void buildCellInfo(Graphics2D g2d, float availableWidthForText) {
        for (int row = 0; row < this.cellInfo.length; ++row) {
            for (int column = 0; column < this.cellInfo[row].length; ++column) {
                String text = this.getCellText(row, column);
                ImageIcon image = this.getCellImage(row, column);
                boolean isNumber = this.isCellNumber(row, column);
                if (this.cellInfo[row][column] == null) {
                    this.cellInfo[row][column] = new CellInfo(this.defaultFont);
                }
                g2d.setFont(this.cellInfo[row][column].font);
                this.cellInfo[row][column].image = image;
                this.cellInfo[row][column].isNumber = isNumber;
                this.cellInfo[row][column].text = text;
                if (this.columnWeight == null) continue;
                float maxWidth = availableWidthForText * this.columnWeight[column] - this.horizontalInset;
                this.cellInfo[row][column].text = this.textTool.wrapText(g2d, text, (int)maxWidth, this.getLineWrap());
            }
        }
    }

    private void distributeSpaceEvenly(float imageableWidth, float availableWidthForText, float linesWidth) {
        this.tableWidth = imageableWidth;
        float totalColumnSize = 0.0f;
        for (int column = 0; column < this.columnSize.length; ++column) {
            totalColumnSize += this.columnSize[column];
        }
        float blankSpaceByColumn = (availableWidthForText - totalColumnSize) / (float)this.columnSize.length;
        if (blankSpaceByColumn <= 0.0f) {
            return;
        }
        if (!this.adjustWidth) {
            blankSpaceByColumn /= 8.0f;
        }
        int column = 0;
        while (column < this.columnSize.length) {
            int n = column++;
            this.columnSize[n] = this.columnSize[n] + blankSpaceByColumn;
        }
        if (!this.adjustWidth) {
            this.tableWidth = (totalColumnSize += blankSpaceByColumn * (float)this.columnSize.length) + linesWidth;
            switch (this.alignment) {
                case 0: {
                    this.xInset = 0.0f;
                    break;
                }
                case 1: {
                    this.xInset = imageableWidth - this.tableWidth;
                    break;
                }
                case 2: {
                    this.xInset = (imageableWidth - this.tableWidth) / 2.0f;
                }
            }
        }
    }

    private void distributeSpaceProportionally(float imageableWidth, float availableWidthForText) {
        this.tableWidth = imageableWidth;
        for (int col = 0; col < this.columnSize.length; ++col) {
            this.columnSize[col] = availableWidthForText * this.columnWeight[col];
        }
    }

    private void joinColumnGroups() {
        for (TableColumnGroup group : this.columnGroups) {
            int colOffset = this.model.hasRowNames() ? 1 : 0;
            int startCol = group.getStartIndex() + colOffset;
            int endCol = group.getEndIndex() + colOffset;
            this.joinColumns(-2, startCol, endCol);
        }
    }

    private void calculatePreferredCellSize(Graphics2D g2d) {
        Point2D.Float pt = new Point2D.Float(0.0f, 0.0f);
        Rectangle2D.Float bbox = new Rectangle2D.Float();
        for (int row = 0; row < this.cellInfo.length; ++row) {
            for (int column = 0; column < this.cellInfo[row].length; ++column) {
                float preferredCellWidth = 0.0f;
                float preferredCellHeight = 0.0f;
                if (this.cellInfo[row][column].image == null) {
                    this.textTool.getBBox(g2d, this.cellInfo[row][column].text, pt, "nw", bbox);
                    preferredCellWidth = this.isJoined(row, column) ? 0.0f : (float)((RectangularShape)bbox).getWidth() + 2.0f * this.horizontalInset;
                    preferredCellHeight = (float)((RectangularShape)bbox).getHeight() + 2.0f * this.verticalInset;
                } else {
                    preferredCellWidth = (float)this.cellInfo[row][column].image.getIconWidth() + 2.0f * this.horizontalInset;
                    preferredCellHeight = (float)this.cellInfo[row][column].image.getIconHeight() + 2.0f * this.verticalInset;
                }
                if (this.lineWidth > 0.0f) {
                    if (row == 0) {
                        preferredCellHeight += this.lineWidth;
                    }
                    preferredCellHeight += this.lineWidth;
                }
                this.rowHeight[row] = Math.max(this.rowHeight[row], preferredCellHeight);
                this.columnSize[column] = Math.max(this.columnSize[column], preferredCellWidth);
            }
        }
    }

    private void calculateColumnGroupsPreferredWidth(Graphics2D g2d) {
        Point2D.Float pt = new Point2D.Float(0.0f, 0.0f);
        Rectangle2D.Float bbox = new Rectangle2D.Float();
        for (TableColumnGroup columnGroup : this.columnGroups) {
            float colGroupRemaining;
            int startIndex = columnGroup.getStartIndex();
            int endIndex = columnGroup.getEndIndex();
            float currentNeighborColumnSizes = 0.0f;
            for (int i = startIndex; i <= endIndex; ++i) {
                currentNeighborColumnSizes += this.columnSize[i];
            }
            float colGroupSize = 0.0f;
            if (this.cellInfo[0][startIndex].image == null) {
                this.textTool.getBBox(g2d, this.cellInfo[0][startIndex].text, pt, "nw", bbox);
                colGroupSize = (float)((RectangularShape)bbox).getWidth() + 2.0f * this.horizontalInset;
            } else {
                colGroupSize = (float)this.cellInfo[0][startIndex].image.getIconWidth() + 2.0f * this.horizontalInset;
            }
            if (!((colGroupRemaining = colGroupSize - currentNeighborColumnSizes) > 0.0f)) continue;
            this.shareRemainingAmongColumnSizes(colGroupRemaining, startIndex, endIndex, currentNeighborColumnSizes);
        }
    }

    private String getCellText(int row, int column) {
        String text = null;
        if (this.columnGroups != null && row == 0) {
            for (TableColumnGroup group : this.columnGroups) {
                if (column != group.getStartIndex()) continue;
                text = group.getName();
                break;
            }
        } else if (row == 0 || this.columnGroups != null && row == 1) {
            String cornerName = this.model.getCornerName();
            text = cornerName != null ? (column == 0 ? cornerName : this.model.getColumnName(column - 1)) : this.model.getColumnName(column);
        } else {
            int adjustedRow;
            int n = adjustedRow = this.columnGroups == null ? row - 1 : row - 2;
            if (column == 0 && this.model.hasRowNames()) {
                text = this.model.getRowName(adjustedRow);
            } else {
                Object value = this.model.hasRowNames() ? this.model.getValueAt(adjustedRow, column - 1) : this.model.getValueAt(adjustedRow, column);
                if (value == null) {
                    text = "";
                } else if (FooterCell.class.isInstance(value)) {
                    value = ((FooterCell)FooterCell.class.cast(value)).getValue();
                }
                if (value == null) {
                    text = "";
                } else if (Colored.class.isInstance(value)) {
                    value = ((Colored)Colored.class.cast(value)).getValue();
                }
                text = value == null ? "" : (value instanceof Date ? this.dateFormat.format((Date)value) : (value instanceof Number ? this.decimalFormat.format(value) : (value instanceof Boolean ? ((Boolean)value != false ? trueString : falseString) : value.toString())));
            }
        }
        if (text == null) {
            text = "";
        }
        return text;
    }

    private boolean isCellNumber(int row, int column) {
        boolean isNumber = false;
        if (row == 0) {
            return false;
        }
        if (row == 1 && this.columnGroups != null) {
            return false;
        }
        int adjustedRow = this.columnGroups == null ? row - 1 : row - 2;
        Object value = this.model.hasRowNames() ? this.model.getValueAt(adjustedRow, column - 1) : this.model.getValueAt(adjustedRow, column);
        if (FooterCell.class.isInstance(value)) {
            value = ((FooterCell)FooterCell.class.cast(value)).getValue();
        } else if (Colored.class.isInstance(value)) {
            value = ((Colored)Colored.class.cast(value)).getValue();
        }
        if (value instanceof Number) {
            isNumber = true;
        }
        return isNumber;
    }

    private ImageIcon getCellImage(int row, int column) {
        ImageIcon image = null;
        if (row == 0) {
            return null;
        }
        if (row == 1 && this.columnGroups != null) {
            return null;
        }
        int adjustedRow = this.columnGroups == null ? row - 1 : row - 2;
        Object value = this.model.hasRowNames() ? this.model.getValueAt(adjustedRow, column - 1) : this.model.getValueAt(adjustedRow, column);
        if (FooterCell.class.isInstance(value)) {
            value = ((FooterCell)FooterCell.class.cast(value)).getValue();
        } else if (Colored.class.isInstance(value)) {
            value = ((Colored)Colored.class.cast(value)).getValue();
        }
        if (ImageIcon.class.isInstance(value)) {
            image = (ImageIcon)ImageIcon.class.cast(value);
        }
        return image;
    }

    private void shareRemainingAmongColumnSizes(float colGroupRemaining, int startIndex, int endIndex, float totalColumnSizes) {
        for (int i = startIndex; i <= endIndex; ++i) {
            int n = i;
            this.columnSize[n] = this.columnSize[n] + colGroupRemaining * this.columnSize[i] / totalColumnSizes;
        }
    }

    private void init(Graphics2D g2d, int page, float imageableWidth) {
        if (this.columnGroups != null) {
            this.joinColumnGroups();
        }
        float linesWidth = 0.0f;
        float availableWidthForText = imageableWidth;
        if (this.drawLines) {
            linesWidth = this.lineWidth * (float)(this.columnSize.length + 1);
            availableWidthForText = imageableWidth - linesWidth;
        }
        this.buildCellInfo(g2d, availableWidthForText);
        this.calculatePreferredCellSize(g2d);
        if (this.columnGroups != null) {
            this.calculateColumnGroupsPreferredWidth(g2d);
        }
        if (this.columnWeight != null) {
            this.distributeSpaceProportionally(imageableWidth, availableWidthForText);
        } else {
            this.distributeSpaceEvenly(imageableWidth, availableWidthForText, linesWidth);
        }
        this.nextRow = 0;
        this.lastRow = -1;
        this.nextCol = 0;
        this.lastCol = -1;
        this.height = 0.0f;
        this.width = 0.0f;
        this.titlePage = page;
        this.firstPage = page;
        this.lastPage = page - 1;
    }

    @Override
    public void setDefaultFont(Font font) {
        this.defaultFont = font;
    }

    @Override
    public void setCellFont(int fromRow, int toRow, int fromColumn, int toColumn, Font font) {
        ++fromRow;
        ++toRow;
        if (this.columnGroups != null) {
            ++fromRow;
            ++toRow;
        }
        if (this.model.hasRowNames()) {
            ++fromColumn;
            ++toColumn;
        }
        for (int row = fromRow; row <= toRow; ++row) {
            for (int column = fromColumn; column <= toColumn; ++column) {
                this.cellInfo[row][column] = new CellInfo(font);
            }
        }
    }

    @Override
    public void setColumnNameFont(int fromColumn, int toColumn, Font font) {
        if (this.model.hasRowNames()) {
            ++fromColumn;
            ++toColumn;
        }
        for (int column = fromColumn; column <= toColumn; ++column) {
            this.cellInfo[0][column] = new CellInfo(font);
            if (this.columnGroups == null) continue;
            this.cellInfo[1][column] = new CellInfo(font);
        }
    }

    @Override
    public void setRowNameFont(int fromRow, int toRow, Font font) {
        if (this.model.hasRowNames()) {
            ++fromRow;
            ++toRow;
            if (this.columnGroups != null) {
                ++fromRow;
                ++toRow;
            }
            for (int row = fromRow; row <= toRow; ++row) {
                this.cellInfo[row][0] = new CellInfo(font);
            }
        }
    }

    @Override
    public void setCornerNameFont(Font font) {
        if (this.model.getCornerName() != null) {
            int row = 0;
            if (this.columnGroups != null) {
                row = 1;
            }
            this.cellInfo[row][0] = new CellInfo(font);
        }
    }

    @Override
    public void setLineWidth(float lineWidth) {
        this.lineWidth = lineWidth;
        this.drawLines = lineWidth >= 0.0f;
    }

    @Override
    public void setInsets(float dx, float dy) {
        this.horizontalInset = dx;
        this.verticalInset = dy;
    }

    @Override
    public void setPosText(String posText) {
        this.setPosText(posText, this.defaultFont);
    }

    @Override
    public void setPosText(String posText, Font posTextFont) {
        this.posText = posText;
        this.posTextFont = posTextFont;
        this.modifiedPosTextFont = posTextFont.deriveFont((float)posTextFont.getSize() * this.configuration.getFontRate());
    }

    @Override
    public void setTableHeader(String header) {
        this.setTableHeader(header, this.defaultFont);
    }

    @Override
    public void setTableHeader(String header, Font headerFont) {
        this.header = header;
        this.headerFont = headerFont;
        this.modifiedHeaderFont = headerFont.deriveFont((float)headerFont.getSize() * this.configuration.getFontRate());
    }

    @Override
    public void setTitle(String title) {
        this.setTitle(title, this.defaultFont);
    }

    @Override
    public void setTitle(String title, Font titleFont) {
        this.title = title;
        this.titleFont = titleFont;
        this.modifiedTitleFont = titleFont.deriveFont((float)titleFont.getSize() * this.configuration.getFontRate());
    }

    @Override
    public void setDateFormat(DateFormat dateFormat) {
        this.dateFormat = dateFormat;
    }

    @Override
    public void setDecimalFormat(NumberFormat decimalFormat) {
        this.decimalFormat = decimalFormat;
    }

    private boolean drawText(Graphics2D g2d, PageFormat format, String text, Point2D pt, String ref, String alignment, boolean force, boolean draw) {
        float y = (float)format.getImageableY();
        float h = (float)format.getImageableHeight();
        Rectangle2D.Float bbox = new Rectangle2D.Float();
        this.textTool.getBBox(g2d, text, pt, ref, bbox);
        if (bbox.getMaxY() > (double)(y + h) && !force) {
            return false;
        }
        if (draw) {
            this.textTool.draw(g2d, text, pt, ref, alignment);
        }
        this.height = (float)((double)this.height + ((RectangularShape)bbox).getHeight());
        this.width = (float)((double)this.width + ((RectangularShape)bbox).getWidth());
        return true;
    }

    @Override
    public boolean simulatePrint(Graphics2D g2d, PageFormat format, int page) {
        if (!this.simulating) {
            this.init(g2d, page, (float)format.getImageableWidth());
            this.simulating = true;
        }
        if (page == this.firstPage && !this.breakTable && !this.print(g2d, format, page, false)) {
            this.init(g2d, page, (float)format.getImageableWidth());
            return false;
        }
        return this.print(g2d, format, page, false);
    }

    @Override
    public boolean print(Graphics2D g2d, PageFormat format, int page) {
        if (!this.printing) {
            this.init(g2d, page, (float)format.getImageableWidth());
            this.printing = true;
        }
        if (page == this.firstPage && !this.breakTable && !this.print(g2d, format, page, false)) {
            this.init(g2d, page, (float)format.getImageableWidth());
            return false;
        }
        return this.print(g2d, format, page, true);
    }

    private int calculateColumnsInPage(float x, float availableWidth) {
        int numCols = 0;
        float lastX = x + this.width + this.lineWidth;
        for (int col = this.nextCol; col < this.columnCount && !(lastX + this.columnSize[col] + this.lineWidth > x + availableWidth); ++col) {
            lastX += this.columnSize[col] + this.lineWidth;
            ++numCols;
        }
        return numCols;
    }

    private int calculateRowsInPage(float y, float availableHeight) {
        int numRows = 0;
        this.lastY = y + this.height;
        for (int row = this.nextRow; row < this.rowHeight.length && !(this.lastY + this.rowHeight[row] > y + availableHeight); ++row) {
            this.lastY += this.rowHeight[row];
            ++numRows;
        }
        return numRows;
    }

    private void drawHorizontalLines(Graphics2D g2d, float x, float y, int numRows) {
        float halfLineWidth = this.lineWidth / 2.0f;
        Line2D.Float line = new Line2D.Float();
        g2d.setStroke(new BasicStroke(this.lineWidth, 0, 2));
        float y1 = y + this.height;
        ((Line2D)line).setLine(x, y1 + halfLineWidth, x + this.tableWidth, y1 + halfLineWidth);
        g2d.draw(line);
        for (int row = this.nextRow; row < this.nextRow + numRows; ++row) {
            y1 += this.rowHeight[row];
            if (this.lineBorderInvisible.get(row)) continue;
            ((Line2D)line).setLine(x, y1 - halfLineWidth, x + this.tableWidth, y1 - halfLineWidth);
            g2d.draw(line);
        }
    }

    private void drawVerticalLines(Graphics2D g2d, float x, float y, int numCols) {
        float halfLineWidth = this.lineWidth / 2.0f;
        Line2D.Float line = new Line2D.Float();
        float x1 = x;
        ((Line2D)line).setLine(x1 + halfLineWidth, y + this.height, x1 + halfLineWidth, this.lastY);
        g2d.draw(line);
        for (int column = this.nextCol; column < this.nextCol + numCols; ++column) {
            float adjustedY = y;
            if (this.columnGroups != null && this.nextRow == 0 && this.isInColumnGroup(column)) {
                adjustedY += this.rowHeight[0];
            }
            x1 += this.lineWidth + this.columnSize[column];
            if (this.columnBorderInvisible.get(column)) continue;
            ((Line2D)line).setLine(x1 + halfLineWidth, adjustedY + this.height, x1 + halfLineWidth, this.lastY);
            g2d.draw(line);
        }
    }

    private boolean print(Graphics2D g2d, PageFormat format, int page, boolean draw) {
        Point2D.Float pt;
        boolean pageEmpty = true;
        float x = (float)format.getImageableX() + this.xInset;
        float y = (float)format.getImageableY();
        float availableWidth = (float)format.getImageableWidth();
        float availableHeight = (float)format.getImageableHeight();
        this.height = 0.0f;
        if (this.title != null && page == this.titlePage) {
            pt = new Point2D.Float(x + this.tableWidth / 2.0f, y);
            boolean force = page > this.firstPage;
            g2d.setFont(this.modifiedTitleFont);
            if (!this.drawText(g2d, format, this.title, pt, "n ", "center", force, draw)) {
                this.titlePage = page + 1;
                if (this.titlePage > this.firstPage + 1) {
                    return true;
                }
                this.lastPage = page;
                return false;
            }
            pageEmpty = false;
        }
        if (this.header != null) {
            pt = new Point2D.Float(x, y + this.height);
            g2d.setFont(this.modifiedHeaderFont);
            if (!this.drawText(g2d, format, this.header, pt, "nw", "left", false, draw)) {
                if (!pageEmpty || page == this.firstPage) {
                    this.lastPage = page;
                    return false;
                }
                return true;
            }
            pageEmpty = false;
        }
        this.width = 0.0f;
        if (page > this.lastPage && this.lastRow > 0) {
            if (this.lastCol == this.columnCount - 1) {
                this.nextRow = this.lastRow + 1;
                this.nextCol = 0;
                ++this.verticalPagesCount;
            } else {
                this.nextRow = this.verticalPagesCount * this.lastPageNumRows;
                this.nextCol = this.lastCol + 1;
            }
        }
        if (this.nextRow < this.cellInfo.length) {
            int numRows;
            int numCols = this.calculateColumnsInPage(x, availableWidth);
            this.lastPageNumRows = numRows = this.calculateRowsInPage(y, availableHeight);
            if (numRows == 0 && pageEmpty && page != this.firstPage) {
                return true;
            }
            if (numRows == 0 && !pageEmpty && page != this.titlePage) {
                return true;
            }
            if (numRows == 0 && !pageEmpty) {
                this.lastPage = page;
                return false;
            }
            if (draw && this.drawLines) {
                this.drawHorizontalLines(g2d, x, y, numRows);
                this.drawVerticalLines(g2d, x, y, numCols);
            }
            Shape oldClip = g2d.getClip();
            Rectangle2D.Float clip = new Rectangle2D.Float();
            Point2D.Float pt2 = new Point2D.Float();
            for (int row = this.nextRow; row < this.nextRow + numRows; ++row) {
                float x1 = x;
                float y1 = y + this.height;
                for (int column = this.nextCol; column < this.nextCol + numCols; ++column) {
                    String alignment;
                    String ref;
                    float columnWidth = this.getColumnWidth(row, column);
                    if (columnWidth < 0.0f) continue;
                    if (row == 0 || this.columnGroups != null && row == 1) {
                        float yOffset = row == 0 ? this.lineWidth : 0.0f;
                        float lineOffset = row == 0 ? 2.0f * this.lineWidth : this.lineWidth;
                        ((Rectangle2D)clip).setRect(x1 + this.lineWidth, y1 + yOffset, columnWidth, this.rowHeight[row] - lineOffset);
                        if (!this.alignTableHeader) {
                            ((Point2D)pt2).setLocation(x1 + this.lineWidth + columnWidth / 2.0f, y1 + this.rowHeight[row] / 2.0f);
                            ref = "c";
                            alignment = "center";
                        } else {
                            if (this.cellInfo[row + 1][column].isNumber) {
                                ((Point2D)pt2).setLocation(x1 + this.lineWidth + columnWidth - this.horizontalInset, y1 + (this.rowHeight[row] - this.lineWidth) / 2.0f);
                                ref = "e";
                            } else {
                                ((Point2D)pt2).setLocation(x1 + this.lineWidth + this.horizontalInset, y1 + (this.rowHeight[row] - this.lineWidth) / 2.0f);
                                ref = "w";
                            }
                            alignment = "left";
                        }
                    } else {
                        Integer cellAlignment;
                        ((Rectangle2D)clip).setRect(x1 + this.lineWidth, y1, columnWidth, this.rowHeight[row] - this.lineWidth);
                        if (this.cellInfo[row][column].isNumber) {
                            cellAlignment = this.columnAlignments.get(column);
                            if (cellAlignment == null) {
                                cellAlignment = 1;
                            }
                            this.setRefPointLocation(pt2, this.lineWidth, row, x1, y1, columnWidth, cellAlignment);
                            ref = this.getCellReference(cellAlignment);
                        } else if (this.cellInfo[row][column].image != null) {
                            int imgWidth = this.cellInfo[row][column].image.getIconWidth();
                            int imgHeight = this.cellInfo[row][column].image.getIconHeight();
                            ((Point2D)pt2).setLocation(x1 + this.lineWidth + (columnWidth - (float)imgWidth) / 2.0f, y1 + this.lineWidth + (this.rowHeight[row] - (float)imgHeight) / 2.0f);
                            ref = "e";
                        } else {
                            cellAlignment = this.columnAlignments.get(column);
                            if (cellAlignment == null) {
                                cellAlignment = 0;
                            }
                            this.setRefPointLocation(pt2, this.lineWidth, row, x1, y1, columnWidth, cellAlignment);
                            ref = this.getCellReference(cellAlignment);
                        }
                        alignment = "left";
                    }
                    g2d.setClip(clip);
                    g2d.setFont(this.cellInfo[row][column].font);
                    String text = this.cellInfo[row][column].text;
                    ImageIcon image = this.cellInfo[row][column].image;
                    if (draw) {
                        this.fillBackground(g2d, this.lineWidth, row, column, x1, y1);
                        if (image == null) {
                            this.textTool.draw(g2d, text, pt2, ref, alignment);
                        } else {
                            this.drawImage(image, g2d, (int)((Point2D)pt2).getX(), (int)((Point2D)pt2).getY());
                        }
                    }
                    x1 += columnWidth + this.lineWidth;
                    this.width += this.columnSize[column];
                }
                this.height += this.rowHeight[row];
            }
            g2d.setClip(oldClip);
            this.lastRow = this.nextRow + numRows - 1;
            this.lastCol = this.nextCol + numCols - 1;
            if (this.nextRow + numRows < this.cellInfo.length || this.nextCol + numCols < this.columnCount) {
                this.lastPage = page;
                return false;
            }
            pageEmpty = false;
        }
        if (this.posText != null) {
            Point2D.Float pt3 = new Point2D.Float(x, y + this.height);
            g2d.setFont(this.modifiedPosTextFont);
            if (!this.drawText(g2d, format, this.posText, pt3, "nw", "left", false, draw)) {
                if (!pageEmpty) {
                    this.lastPage = page;
                    return false;
                }
                return true;
            }
            pageEmpty = false;
        }
        this.lastPage = page;
        return true;
    }

    private void fillBackground(Graphics2D g2d, float sW, int row, int col, float x, float y) {
        Color background = this.cellBackground[row][col];
        if (background != null) {
            Paint paintBackup = g2d.getPaint();
            g2d.setPaint(background);
            Rectangle2D.Float rect = row == 0 ? new Rectangle2D.Float(x + sW, y + sW, this.getColumnWidth(row, col), this.rowHeight[row] - 2.0f * sW) : new Rectangle2D.Float(x + sW, y, this.getColumnWidth(row, col), this.rowHeight[row] - sW);
            g2d.fill(rect);
            g2d.setPaint(paintBackup);
        }
    }

    private void setRefPointLocation(Point2D pt, float _lineWidth, int row, float x1, float y1, float columnWidth, int alignment) {
        switch (alignment) {
            case 0: {
                pt.setLocation(x1 + _lineWidth + this.horizontalInset, y1 + (this.rowHeight[row] - _lineWidth) / 2.0f);
                break;
            }
            case 2: {
                pt.setLocation(x1 + (this.lineWidth + columnWidth - this.horizontalInset) / 2.0f, y1 + (this.rowHeight[row] - _lineWidth) / 2.0f);
                break;
            }
            case 1: {
                pt.setLocation(x1 + _lineWidth + columnWidth - this.horizontalInset, y1 + (this.rowHeight[row] - _lineWidth) / 2.0f);
                break;
            }
            default: {
                throw new IllegalArgumentException("alignment: " + alignment);
            }
        }
    }

    private String getCellReference(int alignment) {
        switch (alignment) {
            case 0: {
                return "w";
            }
            case 2: {
                return "c";
            }
            case 1: {
                return "e";
            }
        }
        throw new IllegalArgumentException("alignment: " + alignment);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void drawImage(ImageIcon image, Graphics2D g2, int x, int y) {
        int height = image.getIconHeight();
        int width = image.getIconWidth();
        Image img = image.getImage();
        this.imageRenderingDone = false;
        boolean drawn = g2.drawImage(img, x, y, width, height, this);
        if (!drawn) {
            while (true) {
                DefaultPrintableTable defaultPrintableTable = this;
                synchronized (defaultPrintableTable) {
                    if (this.imageRenderingDone) {
                        break;
                    }
                }
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {}
            }
        }
    }

    @Override
    public synchronized boolean imageUpdate(Image img, int infoflags, int x, int y, int width, int height) {
        this.imageRenderingDone = (infoflags & 0x70) != 0;
        return !this.imageRenderingDone;
    }

    private boolean isInColumnGroup(int column) {
        for (TableColumnGroup group : this.columnGroups) {
            if (column < group.getStartIndex() || column >= group.getEndIndex()) continue;
            return true;
        }
        return false;
    }

    private float getColumnWidth(int row, int column) {
        if (this.isJoined(row, column)) {
            if (this.isFirstJoinColumn(row, column)) {
                float width = this.columnSize[column];
                int col = column;
                do {
                    width += this.lineWidth + this.columnSize[++col];
                } while (!this.isLastJoinColumn(row, col));
                return width;
            }
            return -1.0f;
        }
        return this.columnSize[column];
    }

    private boolean isFirstJoinColumn(int row, int column) {
        if (!this.isJoined(row, column)) {
            throw new IllegalStateException("Linha e coluna n\u00e3o est\u00e3o agrupadas");
        }
        if (column == 0) {
            return true;
        }
        return this.joinColumns[row].get(column) && !this.joinColumns[row].get(column - 1);
    }

    private boolean isLastJoinColumn(int row, int column) {
        if (!this.isJoined(row, column)) {
            throw new IllegalStateException("Linha e coluna n\u00e3o est\u00e3o agrupadas");
        }
        if (column == 0) {
            return false;
        }
        return !this.joinColumns[row].get(column) && this.joinColumns[row].get(column - 1);
    }

    @Override
    public float getHeight() {
        return this.height;
    }

    @Override
    public void setNamesDefaultFont(Font font) {
        this.setRowNameFont(0, this.model.getRowCount() - 1, font);
        this.setColumnNameFont(0, this.model.getColumnCount() - 1, font);
    }

    @Override
    public void setColumnPart(float[] columnPart) {
        if (columnPart.length != this.columnSize.length) {
            throw new IllegalArgumentException("N\u00famero de colunas diferente do n\u00famero de colunas da tabela");
        }
        float total = 0.0f;
        for (float part : columnPart) {
            total += part;
        }
        float factor = 1.0f / total;
        for (int i = 0; i < columnPart.length; ++i) {
            columnPart[i] = columnPart[i] * factor;
        }
        this.columnWeight = columnPart;
    }

    @Override
    public void setAdjustWidth(boolean adjustWidth) {
        this.adjustWidth = adjustWidth;
    }

    @Override
    public void setColumnAlignment(int[] columnIndexes, int alignment) {
        if (columnIndexes == null) {
            throw new IllegalArgumentException("columnIndexes == null");
        }
        for (int i = 0; i < columnIndexes.length; ++i) {
            this.columnAlignments.put(columnIndexes[i], alignment);
        }
    }

    @Override
    public void setAlignment(int alignment) {
        this.alignment = alignment;
    }

    @Override
    public void joinColumns(int row, int startCol, int endCol) {
        int rowIndex = row + 1;
        if (this.columnGroups != null) {
            ++rowIndex;
        }
        this.joinColumns[rowIndex].set(startCol, endCol);
    }

    private boolean isJoined(int row, int column) {
        if (column == 0) {
            return this.joinColumns[row].get(column);
        }
        return this.joinColumns[row].get(column) || this.joinColumns[row].get(column - 1);
    }

    @Override
    public void setColumnBorderVisible(int startCol, int endCol, boolean visible) {
        this.columnBorderInvisible.set(startCol, endCol, !visible);
    }

    @Override
    public void setLineBorderVisible(int startRow, int endRow, boolean visible) {
        int startRowIndex = startRow + 1;
        int endRowIndex = endRow + 1;
        this.lineBorderInvisible.set(startRowIndex, endRowIndex, !visible);
    }

    public TableModel getModel() {
        return this.model.getModel();
    }

    public void setAlignTableHeader(boolean alignTableHeader) {
        this.alignTableHeader = alignTableHeader;
    }

    public String getLineWrap() {
        return this.lineWrap;
    }

    public void setLineWrap(String lineWrap) {
        this.lineWrap = lineWrap;
    }

    @Override
    public void initPrinting(PrintConfiguration configuration) {
        this.printing = false;
        this.simulating = false;
        this.configuration = configuration;
        this.breakTable = configuration.isTableBreak();
        if (!this.changeCellFont) {
            return;
        }
        for (int row = 0; row < this.rowHeight.length; ++row) {
            this.rowHeight[row] = 0.0f;
        }
        if (!this.changeTextFont) {
            return;
        }
        float fontRate = configuration.getFontRate();
        if (this.posTextFont != null) {
            this.modifiedPosTextFont = this.posTextFont.deriveFont((float)this.posTextFont.getSize() * fontRate);
        }
        if (this.headerFont != null) {
            this.modifiedHeaderFont = this.headerFont.deriveFont((float)this.headerFont.getSize() * fontRate);
        }
        if (this.titleFont != null) {
            this.modifiedTitleFont = this.titleFont.deriveFont((float)this.titleFont.getSize() * fontRate);
        }
    }

    @Override
    public float getWidth() {
        return this.tableWidth;
    }

    @Override
    public void setRowColor(int row, int startCol, int endCol, Color color) {
        for (int i = startCol; i <= endCol; ++i) {
            this.cellBackground[row][i] = color;
        }
    }

    @Override
    public void setColumnColor(int column, int startRow, int endRow, Color color) {
        for (int i = startRow; i <= endRow; ++i) {
            this.cellBackground[i][column] = color;
        }
    }

    private class CellInfo {
        Font font;
        String text;
        boolean isNumber;
        public ImageIcon image;

        CellInfo(Font font) {
            this.font = !DefaultPrintableTable.this.changeCellFont ? font : font.deriveFont(font.getSize2D() * DefaultPrintableTable.this.configuration.getFontRate());
        }
    }
}

