package tecgraf.javautils.gui.calendar;

/**
 * Evento de seleo de data no {@link CalendarDateField}
 *
 */
public class CalendarEvent {

  private long date;
  private boolean monthChanged;

  /**
   * Construtor
   * @param date data selecionada em milisegundos
   * @param monthChanged boolean para indicar se a data selecionada pertence ao mesmo ms e ano da anterior
   */
  public CalendarEvent(long date, boolean monthChanged) {
    this.date = date;
    this.monthChanged = monthChanged;
  }

  /**
   * Obtm a data selecionada em milisegundos
   * @return  long
   */
  public long getDate() {
    return date;
  }

  /**
   * Indica se a data selecionada pertence ao mesmo ms e ano da data anterior
   * @return boolean
   */
  public boolean isMonthChanged() {
    return monthChanged;
  }

  @Override
  public String toString() {
    return getDate() + " " + isMonthChanged();
  }
}
