/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.javautils.gui.table;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;
import tecgraf.javautils.gui.table.ModifiableObjectTableProvider;
import tecgraf.javautils.gui.table.ObjectTableProvider;

public class ObjectTableModel<T>
extends AbstractTableModel {
    private List<T> rows;
    private ObjectTableProvider<T> provider;

    public ObjectTableModel(List<T> rows, ObjectTableProvider<T> provider) {
        if (rows == null) {
            throw new IllegalArgumentException("rows == null");
        }
        if (provider == null) {
            throw new IllegalArgumentException("provider == null");
        }
        if (provider.getColumnNames() == null) {
            throw new IllegalArgumentException("colNames == null");
        }
        this.rows = rows;
        this.provider = provider;
    }

    public ObjectTableProvider<T> getProvider() {
        return this.provider;
    }

    @Override
    public int getRowCount() {
        return this.rows.size();
    }

    @Override
    public int getColumnCount() {
        return this.provider.getColumnNames().length;
    }

    @Override
    public Object getValueAt(int rowIndex, int colIndex) {
        if (rowIndex < 0 || colIndex < 0) {
            return null;
        }
        return this.provider.getCellValue(this.rows.get(rowIndex), colIndex);
    }

    @Override
    public void setValueAt(Object newValue, int rowIndex, int colIndex) {
        if (rowIndex < 0 || colIndex < 0) {
            return;
        }
        if (!(this.provider instanceof ModifiableObjectTableProvider)) {
            return;
        }
        T row = this.rows.get(rowIndex);
        if (row != null) {
            ((ModifiableObjectTableProvider)this.provider).setValueAt(row, newValue, colIndex);
            this.fireTableCellUpdated(rowIndex, colIndex);
        }
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        if (!(this.provider instanceof ModifiableObjectTableProvider)) {
            return false;
        }
        T row = this.rows.get(rowIndex);
        if (row != null) {
            return ((ModifiableObjectTableProvider)this.provider).isCellEditable(rowIndex, columnIndex);
        }
        return false;
    }

    @Override
    public String getColumnName(int colIndex) {
        return this.provider.getColumnNames()[colIndex];
    }

    @Override
    public Class<?> getColumnClass(int colIndex) {
        Class<?>[] columnClasses = this.provider.getColumnClasses();
        if (columnClasses == null) {
            return super.getColumnClass(colIndex);
        }
        return columnClasses[colIndex];
    }

    public void clear() {
        int size = this.rows.size();
        this.rows = new ArrayList<T>();
        if (size > 0) {
            this.fireTableRowsDeleted(0, size - 1);
        }
    }

    public void setRows(List<T> newRows) {
        if (newRows == null) {
            throw new IllegalArgumentException("newRows == null");
        }
        this.rows = newRows;
        this.fireTableChanged(new TableModelEvent(this));
    }

    public void add(T row) {
        this.add(row, true);
    }

    private void add(T row, boolean notify) {
        if (row == null) {
            throw new IllegalArgumentException("row == null");
        }
        int index = this.rows.indexOf(row);
        if (index != -1) {
            this.rows.set(index, row);
            if (notify) {
                this.fireTableRowsUpdated(index, index);
            }
        } else {
            this.rows.add(row);
            if (notify) {
                index = this.rows.size() - 1;
                this.fireTableRowsInserted(index, index);
            }
        }
    }

    public void addAll(Collection<T> rows) {
        if (rows == null) {
            throw new IllegalArgumentException("rows == null");
        }
        for (T row : rows) {
            this.add(row, false);
        }
        this.fireTableChanged(new TableModelEvent(this));
    }

    public boolean remove(T row) {
        if (row == null) {
            throw new IllegalArgumentException("row == null");
        }
        int index = this.rows.indexOf(row);
        if (index == -1) {
            return false;
        }
        this.rows.remove(index);
        this.fireTableRowsDeleted(index, index);
        return true;
    }

    public T remove(int rowIndex) {
        T row = this.rows.remove(rowIndex);
        this.fireTableRowsDeleted(rowIndex, rowIndex);
        return row;
    }

    public Collection<T> removeAll(int[] rowIndexes) {
        if (rowIndexes == null) {
            throw new IllegalArgumentException("rowIndexes == null");
        }
        ArrayList<T> removedRows = new ArrayList<T>();
        if (rowIndexes.length > 0) {
            int start = Integer.MAX_VALUE;
            int end = 0;
            for (int rowIndex : rowIndexes) {
                removedRows.add(this.rows.get(rowIndex));
                start = Math.min(start, rowIndex);
                end = Math.max(end, rowIndex);
            }
            this.rows.removeAll(removedRows);
            this.fireTableRowsDeleted(start, end);
        }
        return removedRows;
    }

    public Collection<T> removeAll() {
        List<T> allRows = this.getRows();
        this.clear();
        return allRows;
    }

    public boolean modify(T row) {
        if (row == null) {
            throw new IllegalArgumentException("row == null");
        }
        int index = this.rows.indexOf(row);
        if (index == -1) {
            return false;
        }
        this.rows.set(index, row);
        this.fireTableRowsUpdated(index, index);
        return true;
    }

    public List<T> getRows() {
        return this.rows;
    }

    public T getRow(int rowIndex) {
        return this.rows.get(rowIndex);
    }

    public void swapRows(int index1, int index2) {
        Collections.swap(this.getRows(), index1, index2);
        this.fireTableDataChanged();
    }
}

