package tecgraf.javautils.gui.crud.gui.actions;

import java.awt.event.ActionEvent;

import javax.swing.Action;

import tecgraf.javautils.gui.crud.RegistrationImages;
import tecgraf.javautils.gui.crud.gui.main.RegistrationMainPanel;

/**
 * Ao do painel tabular
 * 
 * @author Tecgraf
 * @param <M> Model
 * @param <I> View
 */
public class RegistrationObjectEditAction<M, I> extends
  RegistrationObjectAction<M, I> {

  /**
   * {@inheritDoc}
   */
  @Override
  public void actionPerformed(ActionEvent e) {
    final M object = getObject();
    if (object == null) {
      return;
    }
    final RegistrationMainPanel<M, I> mainPanel = getMainPanel();
    mainPanel.setMode(RegistrationMainPanel.Mode.EDIT);
  }

  /**
   * Construtor
   * 
   * @param mainPanel painel
   * @param object objeto.
   */
  public RegistrationObjectEditAction(RegistrationMainPanel<M, I> mainPanel,
    M object) {
    super(mainPanel, object);

    putValue(Action.NAME, mainPanel.getString("edit.action"));
    putValue(Action.SMALL_ICON, RegistrationImages.ICON_EDIT_16);
  }
}
