/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.javautils.gui.print;

import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.util.ArrayList;
import java.util.Collection;
import tecgraf.javautils.gui.print.PrintConfiguration;
import tecgraf.javautils.gui.print.PrintableReportItem;
import tecgraf.javautils.gui.print.PrintableTable;

public class PrintableReportItemArrayList
extends ArrayList<PrintableReportItem>
implements PrintableReportItem {
    private int level;

    private void setChildrenLevel(PrintableReportItem child) {
        if (PrintableReportItemArrayList.class.isInstance(child)) {
            ((PrintableReportItemArrayList)PrintableReportItemArrayList.class.cast((Object)child)).level = this.level + 1;
        }
        if (PrintableTable.class.isInstance(child)) {
            ((PrintableTable)PrintableTable.class.cast(child)).setAdjustWidth(false);
        }
    }

    @Override
    public void add(int index, PrintableReportItem element) {
        this.setChildrenLevel(element);
        super.add(index, element);
    }

    @Override
    public boolean add(PrintableReportItem e) {
        this.setChildrenLevel(e);
        return super.add(e);
    }

    @Override
    public boolean addAll(Collection<? extends PrintableReportItem> c) {
        for (PrintableReportItem printableReportItem : c) {
            this.setChildrenLevel(printableReportItem);
        }
        return super.addAll(c);
    }

    @Override
    public boolean addAll(int index, Collection<? extends PrintableReportItem> c) {
        for (PrintableReportItem printableReportItem : c) {
            this.setChildrenLevel(printableReportItem);
        }
        return super.addAll(index, c);
    }

    @Override
    public PrintableReportItem set(int index, PrintableReportItem element) {
        if (PrintableReportItemArrayList.class.isInstance(element)) {
            ((PrintableReportItemArrayList)PrintableReportItemArrayList.class.cast((Object)element)).level = this.level + 1;
        }
        return super.set(index, element);
    }

    @Override
    public void initPrinting(PrintConfiguration configuration) {
    }

    @Override
    public boolean print(Graphics2D g2, PageFormat format, int pageIndex) {
        Paper paper = format.getPaper();
        double xBackup = paper.getImageableX();
        double yBackup = paper.getImageableY();
        double widthBackup = paper.getImageableWidth();
        double heightBackup = paper.getImageableHeight();
        Paint paintColorBackup = g2.getPaint();
        for (PrintableReportItem item : this) {
            item.print(g2, format, pageIndex);
            g2.setPaint(paintColorBackup);
            this.adjustImageableArea(format, item.getWidth(), item.getHeight());
        }
        paper.setImageableArea(xBackup, yBackup, widthBackup, heightBackup);
        format.setPaper(paper);
        return true;
    }

    private void adjustImageableArea(PageFormat format, float printableWidth, float printableHeight) {
        Paper paper = format.getPaper();
        double x = paper.getImageableX();
        double y = paper.getImageableY();
        double width = paper.getImageableWidth();
        double height = paper.getImageableHeight();
        if (this.level % 2 == 0) {
            if (format.getOrientation() == 1) {
                x += (double)printableWidth;
                width -= (double)printableWidth;
            }
            if (format.getOrientation() == 0) {
                height -= (double)printableWidth;
            }
        } else {
            if (format.getOrientation() == 0) {
                x += (double)printableHeight;
                width -= (double)printableHeight;
            }
            if (format.getOrientation() == 1) {
                y += (double)printableHeight;
                height -= (double)printableWidth;
            }
        }
        paper.setImageableArea(x, y, width, height);
        format.setPaper(paper);
    }

    @Override
    public boolean simulatePrint(Graphics2D g2, PageFormat format, int pageIndex) {
        return true;
    }

    @Override
    public float getHeight() {
        float totalHeight = 0.0f;
        for (PrintableReportItem item : this) {
            if (this.level % 2 == 0) {
                if (!(totalHeight < item.getHeight())) continue;
                totalHeight = item.getHeight();
                continue;
            }
            totalHeight += item.getHeight();
        }
        return totalHeight;
    }

    @Override
    public float getWidth() {
        float totalWidth = 0.0f;
        for (PrintableReportItem item : this) {
            if (this.level % 2 == 0) {
                totalWidth += item.getWidth();
                continue;
            }
            if (!(totalWidth < item.getWidth())) continue;
            totalWidth = item.getWidth();
        }
        return totalWidth;
    }
}

