/*
 * $Id$
 */
package tecgraf.javautils.gui.print;

import java.awt.print.*;
import java.util.List;

/**
 * Relatrio a ser impresso.
 */
public interface PrintableReport extends Printable, Pageable {
  
  /**
   * Indica o texto que deve ser impresso em todas as pginas do relatrio, no 
   * topo da pgina.
   * 
   * @param header texto a ser impresso em todas as pginas do relatrio, no 
   *               topo da pgina.
   */
  public void setHeader(PrintableReportItem header);
  
  /**
   * Indica a lista dos item a serem impressos no relatrio sequencialmente.
   * 
   * @param printables lista dos item a serem impressos no relatrio.
   */
  public void setPrintables(List<PrintableReportItem> printables);
  
  /**
   * Indica o texto que deve ser impresso em todas as pginas do relatrio, na 
   * parte inferior da pgina.
   * 
   * @param footer texto a ser impresso em todas as pginas do relatrio, na 
   *               parte inferior da pgina.
   */
  public void setFooter(PrintableReportItem footer);
  
  /**
   * Obtm a pgina corrente do relatrio, para que possa ser utilizada como
   * indicao da pgina impressa.
   * 
   * @return pgina corrente do relatrio.
   */
  public int getCurrentPage();
  
  /**
   * Indica a margem horizontal do papel. A margem horizontal independe da
   * orientao da pgina.
   * 
   * @param horizontalMargin a margem horizontal.
   */
  public void setHorizontalMargin(double horizontalMargin);

  /**
   * Indica a margem vertical do papel. A margem vertical independe da
   * orientao da pgina.
   * 
   * @param verticalMargin a margem vertical do papel.
   */
  public void setVerticalMargin(double verticalMargin);
  
  /**
   * Indica a orientao da pgina.
   * @see PageFormat
   * 
   * @param orientation a orientao da pgina.
   */
  public void setOrientation(int orientation);
  
  
  /**
   * Prepara a impresso com determinada configurao de impresso.
   * 
   * @param configuration configurao de impresso.
   */
  public void initPrinting(PrintConfiguration configuration);
  
}
