/*
 * Detalhes da ltima alterao:
 *
 * $Author: rodrigoh $
 * $Date: 2005-12-08 12:00:45 -0200 (Thu, 08 Dec 2005) $
 * $Revision: 2007 $
 */
package tecgraf.javautils.gui.wizard;

import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

/**
 * Representa um ouvinte de eventos de documento que notifica a um passo que
 * tal evento ocorreu.
 *
 * @author Tecgraf/PUC-Rio
 */
public final class WasChangedDocumentListener implements DocumentListener {
  /** O passo que ser notificado. */
  private Step step;

  public void changedUpdate(DocumentEvent e) {
    this.step.notifyChanged();
  }

  public void insertUpdate(DocumentEvent e) {
    this.step.notifyChanged();
  }

  public void removeUpdate(DocumentEvent e) {
    this.step.notifyChanged();
  }

  /**
   * Cria um ouvinte de eventos de documento que notificar a um passo da
   * ocorrncia desse evento.
   *
   * @param step O passo a ser notificado.
   */
  public WasChangedDocumentListener(Step step) {
    this.step = step;
  }
}
