package tecgraf.javautils.gui.wizard;

/**
 * Representa um ouvinte de eventos genricos
 *
 * @author Tecgraf/PUC-Rio
 */
abstract public class WasChangedListener {
  /**
   * O passo que ser notificado.
   */
  private Step step;

  /**
   * Notifica o step da notificao (ver {@link Step#notifyChanged}).
   */
  protected void notifyChangedToStep() {
    this.step.notifyChanged();
  }

  /**
   * Cria um ouvinte de eventos de item que notificar a um passo da ocorrncia
   * desse evento.
   *
   * @param step o passo a ser notificado.
   */
  public WasChangedListener(Step step) {
    this.step = step;
  }
}
