/*
 * $Id: FooterRendererWrapper.java 101729 2010-02-10 16:23:34Z giovani $
 */
package tecgraf.javautils.gui.table;

import javax.swing.table.TableCellRenderer;

/**
 * Classe que "decora" os renderizadores usados para desenhar as clulas de uma
 * tabela com totalizao. Seu papel  simplesmente garantir que os
 * renderizadores vo ter acesso ao valor a ser renderizado, o qual fica
 * encapsulado em outras classes nas clulas presentes nas linhas de
 * totalizao.
 * 
 * @author Tecgraf
 */
public class FooterRendererWrapper extends RespectEnabledStateCellRenderer {

  /**
   * Cria um decorador sobre o renderizador especificado. Mantm a aparncia
   * default da tabela quando esta est desabilitada.
   * 
   * @param renderer renderizador a ser decorado.
   */
  public FooterRendererWrapper(TableCellRenderer renderer) {
    super(renderer, false);
  }

  /**
   * Cria um decorador sobre o renderizador especificado, opcionalmente
   * permitindo que clulas desabilitadas sejam exibidas com aparncia de
   * desabilitadas.
   * 
   * @param renderer renderizador a ser decorado.
   * @param useDisabledLook flag que indica se as clulas desabilitadas devem
   *        ser exibidas como tal. Se igual a true, as clulas parecero
   *        desabilitadas quando a tabela o estiver.
   */
  public FooterRendererWrapper(TableCellRenderer renderer,
    boolean useDisabledLook) {
    super(renderer, useDisabledLook);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected Object convertValue(Object value, int row, int column) {
    if (value instanceof FooterCell) {
      return ((FooterCell) value).getValue();
    }
    return value;
  }
}
