package tecgraf.javautils.gui;

import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

import tecgraf.javautils.gui.table.ObjectTableModel;

/**
 * Exemplo de uso da classe {@link StandardDialogs}.
 *
 * @author Tecgraf/PUC-Rio
 */
public class StandardDialogsSample {

  /**
   * Teste dos mtodos desta classe. Constri uma janela com 5 botes. Cada
   * boto dispara um dilogo.
   *
   * @param args
   */
  public static void main(String[] args) {
    final JFrame frame = new JFrame("Teste da classe StandardDialogs");
    frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
    Container contentPane = frame.getContentPane();
    contentPane.setLayout(new FlowLayout());
    // Teste showWrongDialog
    JButton b1 = new JButton("showWrongDialog");
    b1.addActionListener(
      new ActionListener() {
        public void actionPerformed(ActionEvent e) {
          String title = "Erro";
          String msg = "Teste do showWrongDialog";
          StandardDialogs.showErrorDialog(frame, title, msg);
        }
      });
    contentPane.add(b1);
    // Teste showMessageDialog
    JButton b2 = new JButton("showMessageDialog");
    b2.addActionListener(
      new ActionListener() {
        public void actionPerformed(ActionEvent e) {
          String title = "Informao";
          String msg = "Teste do showMessageDialog";
          StandardDialogs.showInfoDialog(frame, title, msg);
        }
      });
    contentPane.add(b2);
    // Teste showYesNoDialog
    JButton b3 = new JButton("showYesNoDialog");
    b3.addActionListener(
      new ActionListener() {
        public void actionPerformed(ActionEvent e) {
          String title = "Pergunta";
          String msg = "Teste do showYesNoDialog";
          int answer = StandardDialogs.showYesNoDialog(frame, title, msg);
          String option = "";
          switch (answer) {
            case JOptionPane.YES_OPTION:
              option = "Sim";
              break;
            case JOptionPane.NO_OPTION:
              option = "No";
              break;
            case JOptionPane.CLOSED_OPTION:
              option = "(Fechou sem resposta)";
              break;
          }
          StandardDialogs.showInfoDialog(frame, "Resposta", "Escolhida opo "+option);
        }
      });
    contentPane.add(b3);
    // Teste showYesNoCancelDialog
    JButton b4 = new JButton("showYesNoCancelDialog");
    b4.addActionListener(
      new ActionListener() {
        public void actionPerformed(ActionEvent e) {
          String title = "Pergunta";
          String msg = "Teste do showYesNoCancelDialog";
          int answer = StandardDialogs.showYesNoCancelDialog(frame, title, msg);
          String option = "";
          switch (answer) {
            case JOptionPane.YES_OPTION:
              option = "Sim";
              break;
            case JOptionPane.NO_OPTION:
              option = "No";
              break;
            case JOptionPane.CANCEL_OPTION:
              option = "Cancelar";
              break;
            case JOptionPane.CLOSED_OPTION:
              option = "(Fechou sem resposta)";
              break;
          }
          StandardDialogs.showInfoDialog(frame, "Resposta", "Escolhida opo "+option);
        }
      });
    contentPane.add(b4);
    //  Teste showOptionDialog
    JButton b5 = new JButton("showOptionDialog");
    b5.addActionListener(
      new ActionListener() {
        public void actionPerformed(ActionEvent e) {
          String title = "Pergunta";
          String msg = "Teste do showOptionDialog";
          Object[] options = { "Azul", "Verde", "Vermelho" };
          int answer = StandardDialogs.showOptionDialog(frame, title, msg, options);
          String option = "";
          switch (answer) {
            case 0:
              option = "Azul";
              break;
            case 1:
              option = "Verde";
              break;
            case 2:
              option = "Vermelho";
              break;
            case JOptionPane.CLOSED_OPTION:
              option = "(Fechou sem resposta)";
              break;
          }
          StandardDialogs.showInfoDialog(frame, "Resposta", "Escolhida opo "+option);
        }
      });
    contentPane.add(b5);
    frame.setSize(400, 400);
    frame.setVisible(true);
  }
}
