package tecgraf.javautils.gui.wizard.utils.changedlisteners;

import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;

import tecgraf.javautils.gui.wizard.Step;
import tecgraf.javautils.gui.wizard.WasChangedListener;

/**
 * Representa um ouvinte de eventos de item que notifica a um passo que tal
 * evento ocorreu.
 *
 * @author Tecgraf/PUC-Rio
 */
public final class WasChangedItemListener extends WasChangedListener implements
  ItemListener {

  /**
   * {@inheritDoc}
   */
  @Override
  public void itemStateChanged(ItemEvent e) {
    notifyChangedToStep();
  }

  /**
   * Cria um ouvinte de eventos de item que notificar a um passo da ocorrncia
   * desse evento.
   *
   * @param step O passo a ser notificado.
   */
  public WasChangedItemListener(Step step) {
    super(step);
  }
}
