/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.javautils.pdfviewer.core;

import com.sun.pdfview.PDFFile;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import tecgraf.javautils.pdfviewer.core.PDFDocument;
import tecgraf.javautils.pdfviewer.core.PDFRendererPagePanel;
import tecgraf.javautils.pdfviewer.core.listeners.PDFDocumentOpenCloseListener;
import tecgraf.javautils.pdfviewer.core.listeners.PDFPageChangedListener;
import tecgraf.javautils.pdfviewer.core.listeners.PDFZoomChangedListener;
import tecgraf.javautils.pdfviewer.core.listeners.PDFZoomFitPolicyChangedListener;

public class PDFCorePanel
extends JPanel {
    private final JScrollPane scrollPane = new JScrollPane();
    private final PDFRendererPagePanel rendererPanel = new PDFRendererPagePanel();
    private final List<PDFPageChangedListener> pageChangeListeners = new ArrayList<PDFPageChangedListener>();
    private final List<PDFDocumentOpenCloseListener> pdfDocumentOpenCloseListeners = new ArrayList<PDFDocumentOpenCloseListener>();
    private final List<PDFZoomChangedListener> pdfZoomChangedListeners = new ArrayList<PDFZoomChangedListener>();
    private final List<PDFZoomFitPolicyChangedListener> pdfZoomFitChangedListeners = new ArrayList<PDFZoomFitPolicyChangedListener>();
    private final ComponentListener applyZoomFitPolicyListerner = new ComponentAdapter(){

        @Override
        public void componentResized(ComponentEvent e) {
            PDFCorePanel.this.applyZoomFitPolicy();
        }

        @Override
        public void componentShown(ComponentEvent e) {
            PDFCorePanel.this.applyZoomFitPolicy();
        }
    };
    private int pageNumber = -1;
    private PDFFile pdfFile;
    private ZoomFitPolicy zoomFitPolicy = ZoomFitPolicy.WHOLE_PAGE;
    private final ResourceBundle resourceBunble;

    public PDFCorePanel(ResourceBundle resourceBundle) {
        this.resourceBunble = resourceBundle;
        this.setPreferredSize(new Dimension(600, 400));
        this.scrollPane.setViewportView(this.rendererPanel);
        this.layout(this.scrollPane);
    }

    protected void layout(Component pageView) {
        this.setLayout(new BorderLayout());
        this.add(pageView, "Center");
    }

    public void setZoom(double percent) {
        this.setZoomFitPolicy(ZoomFitPolicy.FREE);
        this.rendererPanel.setZoom(percent);
        this.notifyZoomChanged(percent);
    }

    public double getZoom() {
        return this.rendererPanel.getZoom();
    }

    public void loadDocument(PDFDocument document) {
        if (this.hasOpenFile()) {
            this.closePDF();
        }
        this.pdfFile = document.getPDFFile();
        if (this.getTotalPageNumber() > 0) {
            this.openPDF();
        }
    }

    public void addPageChangeListener(PDFPageChangedListener pageChangeListener) {
        this.pageChangeListeners.add(pageChangeListener);
    }

    public void addPDFDocumentOpenCloseListener(PDFDocumentOpenCloseListener listener) {
        this.pdfDocumentOpenCloseListeners.add(listener);
    }

    public void addPDFZoomChangedListener(PDFZoomChangedListener listener) {
        this.pdfZoomChangedListeners.add(listener);
    }

    public void addPDFZoomFitPolicyChangedListener(PDFZoomFitPolicyChangedListener listener) {
        this.pdfZoomFitChangedListeners.add(listener);
    }

    protected void showPageFromNumberOneBased() {
        this.rendererPanel.showPage(this.pdfFile.getPage(this.pageNumber + 1));
        this.notifyPageChanged(this.pageNumber, this.pdfFile.getNumPages());
    }

    protected void notifyPageChanged(int pageNumber, int totalPages) {
        for (PDFPageChangedListener pageChangeListener : this.pageChangeListeners) {
            pageChangeListener.pageChanged(pageNumber, totalPages);
        }
    }

    protected void notifyZoomChanged(double percentage) {
        for (PDFZoomChangedListener zoomChangedListener : this.pdfZoomChangedListeners) {
            zoomChangedListener.zoomChanged(percentage);
        }
    }

    protected void notifyZoomFitPolicyChanged(ZoomFitPolicy zoomFitPolicy) {
        for (PDFZoomFitPolicyChangedListener zoomFitPolicyChangedListener : this.pdfZoomFitChangedListeners) {
            zoomFitPolicyChangedListener.zoomFitPolicyChanged(zoomFitPolicy);
        }
    }

    protected void notifyPDFDocumentOpened() {
        for (PDFDocumentOpenCloseListener documentOpenCloseListener : this.pdfDocumentOpenCloseListeners) {
            documentOpenCloseListener.documentOpened(this);
        }
    }

    protected void notifyPDFDocumentClosed() {
        for (PDFDocumentOpenCloseListener documentOpenCloseListener : this.pdfDocumentOpenCloseListeners) {
            documentOpenCloseListener.documentClosed(this);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setPage(int pageNumber) {
        if (this.pdfFile == null) throw new IllegalStateException("Aquivo PDF n\u00e3o foi carregado");
        if (pageNumber < 0 || pageNumber >= this.pdfFile.getNumPages()) throw new IllegalStateException("P\u00e1gina " + pageNumber + " est\u00e1 fora do limite, que \u00e9 " + pageNumber + " >= 0 && " + pageNumber + "< " + this.pdfFile.getNumPages() + " (n\u00famero total de p\u00e1ginas)");
        if (pageNumber == this.pageNumber) return;
        this.pageNumber = pageNumber;
        this.showPageFromNumberOneBased();
    }

    public boolean canGoToNextPage() {
        return this.pageNumber + 1 < this.pdfFile.getNumPages();
    }

    public boolean canGoToPrevPage() {
        return this.pageNumber - 1 >= 0;
    }

    public boolean goToNextPage() {
        if (this.canGoToNextPage()) {
            ++this.pageNumber;
            this.showPageFromNumberOneBased();
            return true;
        }
        return false;
    }

    public boolean goToPrevPage() {
        if (this.canGoToPrevPage()) {
            --this.pageNumber;
            this.showPageFromNumberOneBased();
            return true;
        }
        return false;
    }

    public void setZoomFitPolicy(ZoomFitPolicy fitPolicy) {
        if (fitPolicy != this.zoomFitPolicy) {
            this.zoomFitPolicy = fitPolicy;
            this.applyZoomFitPolicy();
            this.notifyZoomFitPolicyChanged(fitPolicy);
        }
    }

    public Dimension getDocumentPageSize() {
        Dimension size = this.rendererPanel.getDefaultPageSize();
        return size;
    }

    protected void applyZoomFitPolicy() {
        if (this.zoomFitPolicy == ZoomFitPolicy.FREE) {
            return;
        }
        Dimension oneHundredPercentZoom = this.rendererPanel.getDefaultPageSize();
        if (oneHundredPercentZoom.width > 0 && oneHundredPercentZoom.height > 0) {
            double rendererPanelHeight = this.scrollPane.getHeight() - 4;
            double rendererPanelWidth = this.scrollPane.getWidth() - 4;
            if (this.zoomFitPolicy == ZoomFitPolicy.WIDTH || this.zoomFitPolicy == ZoomFitPolicy.WHOLE_PAGE && rendererPanelHeight >= rendererPanelWidth) {
                double zoomFactor = rendererPanelWidth / (double)oneHundredPercentZoom.width;
                if (oneHundredPercentZoom.getHeight() * zoomFactor > rendererPanelHeight) {
                    double verticalScrollBarWidth = this.getVerticalScrollBarWidth();
                    zoomFactor = (rendererPanelWidth - verticalScrollBarWidth) / (double)oneHundredPercentZoom.width;
                }
                this.rendererPanel.setZoom(zoomFactor * 100.0);
            } else if (this.zoomFitPolicy == ZoomFitPolicy.HEIGHT || this.zoomFitPolicy == ZoomFitPolicy.WHOLE_PAGE && rendererPanelHeight < rendererPanelWidth) {
                double zoomFactor = rendererPanelHeight / (double)oneHundredPercentZoom.height;
                if (oneHundredPercentZoom.getWidth() * zoomFactor > rendererPanelWidth) {
                    double horizontalScrollBarHeight = this.getHorizontalScrollBarHeight();
                    zoomFactor = (rendererPanelHeight - horizontalScrollBarHeight) / (double)oneHundredPercentZoom.height;
                }
                this.rendererPanel.setZoom(zoomFactor * 100.0);
            }
            this.notifyZoomChanged(this.rendererPanel.getZoom());
        }
    }

    protected int getVerticalScrollBarWidth() {
        return (int)this.scrollPane.getVerticalScrollBar().getMaximumSize().getWidth();
    }

    protected int getHorizontalScrollBarHeight() {
        return (int)this.scrollPane.getHorizontalScrollBar().getMaximumSize().getHeight();
    }

    public int getTotalPageNumber() {
        if (this.pdfFile != null) {
            return this.pdfFile.getNumPages();
        }
        throw new IllegalStateException("N\u00e3o h\u00e1 como pegar o n\u00famero total de p\u00e1ginas pois n\u00e3o existe arquivo PDF aberto (pdfFile == null)");
    }

    protected void openPDF() {
        this.rendererPanel.addComponentListener(this.applyZoomFitPolicyListerner);
        this.notifyPDFDocumentOpened();
        this.setPage(0);
        this.zoomFitPolicy = ZoomFitPolicy.FREE;
        this.setZoomFitPolicy(ZoomFitPolicy.WIDTH);
    }

    public void closePDF() {
        this.rendererPanel.removeComponentListener(this.applyZoomFitPolicyListerner);
        this.notifyPDFDocumentClosed();
        this.rendererPanel.showPage(null);
        this.pdfFile = null;
        this.pageNumber = -1;
    }

    public int getPageNumber() {
        return this.pageNumber;
    }

    PDFFile getPDFFile() {
        return this.pdfFile;
    }

    public boolean hasOpenFile() {
        return this.getPDFFile() != null;
    }

    public String getString(String key) {
        return this.resourceBunble.getString(key);
    }

    public static enum ZoomFitPolicy {
        WIDTH,
        HEIGHT,
        WHOLE_PAGE,
        FREE;

    }
}

