/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.javautils.pdfviewer.core;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import tecgraf.javautils.pdfviewer.core.PDFDocument;

public class PDFReader {
    public PDFDocument read(InputStream inputStream) throws IOException {
        byte[] byteBuf = this.toByteArray(inputStream);
        ByteBuffer buf = ByteBuffer.wrap(byteBuf);
        return new PDFDocument(buf);
    }

    private byte[] toByteArray(InputStream input) throws IOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        this.copy(input, output);
        return output.toByteArray();
    }

    private long copyLarge(InputStream input, OutputStream output) throws IOException {
        byte[] buffer = new byte[0x100000];
        long count = 0L;
        int n = 0;
        while (-1 != (n = input.read(buffer))) {
            output.write(buffer, 0, n);
            count += (long)n;
        }
        return count;
    }

    private int copy(InputStream input, OutputStream output) throws IOException {
        long count = this.copyLarge(input, output);
        if (count > Integer.MAX_VALUE) {
            return -1;
        }
        return (int)count;
    }
}

