/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.javautils.sparkserver.utils;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.swagger.jaxrs.Reader;
import io.swagger.jaxrs.config.BeanConfig;
import io.swagger.models.Swagger;
import java.util.HashSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tecgraf.javautils.sparkserver.core.JuIController;

public class JuSwaggerParser {
    private static final Logger logger = LoggerFactory.getLogger(JuSwaggerParser.class);

    public static String getSwaggerJson(JuIController controller) throws JsonProcessingException {
        String title = controller.getClass().getSimpleName().toLowerCase();
        Swagger swagger = JuSwaggerParser.getSwagger(title, controller.getClass());
        String json = JuSwaggerParser.swaggerToJson(swagger);
        return json;
    }

    public static Swagger getSwagger(String title, Class<? extends JuIController> controllerClass) {
        logger.info("Search swagger for class: " + controllerClass);
        HashSet<Class<? extends JuIController>> loadClasses = new HashSet<Class<? extends JuIController>>();
        for (Class<? extends JuIController> cls = controllerClass; cls != null; cls = cls.getSuperclass()) {
            loadClasses.add(cls);
        }
        BeanConfig beanConfig = new BeanConfig();
        beanConfig.setTitle(title);
        beanConfig.setScan(true);
        beanConfig.setPrettyPrint(true);
        beanConfig.scanAndRead();
        beanConfig.setResourcePackage(controllerClass.getPackageName());
        Swagger swagger = beanConfig.getSwagger();
        Reader reader = new Reader(swagger);
        for (Class clazz : loadClasses) {
            logger.info("Swagger API class: " + clazz.getName());
        }
        return reader.read(loadClasses);
    }

    public static String swaggerToJson(Swagger swagger) throws JsonProcessingException {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_EMPTY);
        String json = objectMapper.writeValueAsString((Object)swagger);
        return json;
    }
}

