/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.openbus.admin;

import java.nio.ByteBuffer;
import org.omg.CORBA.Object;
import scs.core.IComponent;
import scs.core.IComponentHelper;
import tecgraf.javautils.core.lng.LNG;
import tecgraf.openbus.Connection;
import tecgraf.openbus.admin.BusAuditFacade;
import tecgraf.openbus.admin.IncompatibleBus;
import tecgraf.openbus.core.v2_1.services.ServiceFailure;
import tecgraf.openbus.core.v2_1.services.UnauthorizedOperation;
import tecgraf.openbus.core.v2_1.services.admin.v1_1.AuditConfiguration;
import tecgraf.openbus.core.v2_1.services.admin.v1_1.AuditConfigurationHelper;
import tecgraf.openbus.core.v2_1.services.admin.v1_1.NameValueString;
import tecgraf.openbus.exception.CryptographyException;
import tecgraf.openbus.security.Cryptography;

public class BusAuditImpl
implements BusAuditFacade {
    private AuditConfiguration audit = null;
    private IComponent bus;
    private Connection conn;

    public BusAuditImpl(Object reference, Connection conn) {
        this.conn = conn;
        this.bus = IComponentHelper.narrow((Object)reference);
        Object auditObj = this.bus.getFacet(AuditConfigurationHelper.id());
        if (auditObj != null) {
            this.audit = AuditConfigurationHelper.narrow((Object)auditObj);
        }
    }

    @Override
    public boolean isAuditCapable() {
        return this.audit != null;
    }

    private void assertAuditCapable() throws IncompatibleBus {
        if (!this.isAuditCapable()) {
            throw new IncompatibleBus(LNG.get((String)"IncompatibleBus.error.auditconfiguration"));
        }
    }

    public boolean getAuditEnabled() throws IncompatibleBus, ServiceFailure {
        this.assertAuditCapable();
        return this.audit.getAuditEnabled();
    }

    public void setAuditEnabled(boolean b) throws IncompatibleBus, ServiceFailure, UnauthorizedOperation {
        this.assertAuditCapable();
        this.audit.setAuditEnabled(b);
    }

    public String getAuditHttpProxy() throws IncompatibleBus, ServiceFailure {
        this.assertAuditCapable();
        return this.audit.getAuditHttpProxy();
    }

    public void setAuditHttpProxy(String s) throws IncompatibleBus, ServiceFailure, UnauthorizedOperation {
        this.assertAuditCapable();
        this.audit.setAuditHttpProxy(s);
    }

    public byte[] getAuditHttpAuth() throws IncompatibleBus, ServiceFailure, UnauthorizedOperation {
        this.assertAuditCapable();
        Cryptography crypto = Cryptography.getInstance();
        byte[] bytes = this.audit.getAuditHttpAuth();
        try {
            return crypto.decrypt(bytes, this.conn.privateKey());
        }
        catch (CryptographyException e) {
            throw new RuntimeException(e);
        }
    }

    public void setAuditHttpAuth(byte[] bytes) throws IncompatibleBus, ServiceFailure, UnauthorizedOperation {
        this.assertAuditCapable();
        Cryptography crypto = Cryptography.getInstance();
        try {
            if (bytes.length == 0) {
                bytes = ByteBuffer.allocate(1).array();
                bytes[0] = 0;
            }
            this.audit.setAuditHttpAuth(crypto.encrypt(bytes, this.conn.busPublicKey()));
        }
        catch (CryptographyException e) {
            throw new RuntimeException(e);
        }
    }

    public String getAuditServiceURL() throws IncompatibleBus, ServiceFailure {
        this.assertAuditCapable();
        return this.audit.getAuditServiceURL();
    }

    public void setAuditServiceURL(String s) throws IncompatibleBus, ServiceFailure, UnauthorizedOperation {
        this.assertAuditCapable();
        this.audit.setAuditServiceURL(s);
    }

    public int getAuditFIFOLimit() throws IncompatibleBus, ServiceFailure {
        this.assertAuditCapable();
        return this.audit.getAuditFIFOLimit();
    }

    public void setAuditFIFOLimit(int i) throws IncompatibleBus, ServiceFailure, UnauthorizedOperation {
        this.assertAuditCapable();
        this.audit.setAuditFIFOLimit(i);
    }

    public int getAuditFIFOLength() throws IncompatibleBus, ServiceFailure {
        this.assertAuditCapable();
        return this.audit.getAuditFIFOLength();
    }

    public boolean getAuditDiscardOnExit() throws IncompatibleBus, ServiceFailure {
        this.assertAuditCapable();
        return this.audit.getAuditDiscardOnExit();
    }

    public void setAuditDiscardOnExit(boolean b) throws IncompatibleBus, ServiceFailure, UnauthorizedOperation {
        this.assertAuditCapable();
        this.audit.setAuditDiscardOnExit(b);
    }

    public int getAuditPublishingTasks() throws IncompatibleBus, ServiceFailure {
        this.assertAuditCapable();
        return this.audit.getAuditPublishingTasks();
    }

    public void setAuditPublishingTasks(int i) throws IncompatibleBus, ServiceFailure, UnauthorizedOperation {
        this.assertAuditCapable();
        this.audit.setAuditPublishingTasks(i);
    }

    public double getAuditPublishingRetryTimeout() throws IncompatibleBus, ServiceFailure {
        this.assertAuditCapable();
        return this.audit.getAuditPublishingRetryTimeout();
    }

    public void setAuditPublishingRetryTimeout(double v) throws IncompatibleBus, ServiceFailure, UnauthorizedOperation {
        this.assertAuditCapable();
        this.audit.setAuditPublishingRetryTimeout(v);
    }

    public void setAuditEventTemplate(String name, String value) throws IncompatibleBus, ServiceFailure, UnauthorizedOperation {
        this.assertAuditCapable();
        this.audit.setAuditEventTemplate(name, value);
    }

    public NameValueString[] getAuditEventTemplate() throws IncompatibleBus, ServiceFailure {
        this.assertAuditCapable();
        return this.audit.getAuditEventTemplate();
    }
}

