/*
 * Decompiled with CFR 0.152.
 */
package busexplorer.desktop.dialog;

import busexplorer.desktop.dialog.JMultilineLabel;
import busexplorer.desktop.dialog.ThrowableTreeNode;
import busexplorer.utils.Utils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import tecgraf.javautils.core.lng.LNG;
import tecgraf.javautils.gui.GBC;
import tecgraf.javautils.gui.GUIUtils;

public abstract class ExceptionDialog
extends JDialog {
    protected final Throwable _throwable;
    protected String[] additionalInfo;

    protected ExceptionDialog(Window owner, String title, Throwable throwable) {
        this(owner, title, throwable, null);
    }

    protected ExceptionDialog(Window owner, String title, Throwable throwable, String[] additionalInfo) {
        super(owner, title);
        this._throwable = throwable;
        this.additionalInfo = additionalInfo;
        this.setWindowClosingMethod();
    }

    private void setWindowClosingMethod() {
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                ExceptionDialog.this.dispose();
            }
        });
    }

    public static ExceptionDialog createDialog(Window window, String title, Throwable throwable) {
        return ExceptionDialog.createDialog(window, title, throwable, (String[])null);
    }

    public static ExceptionDialog createDialog(Window window, String title, Throwable throwable, String message) {
        return ExceptionDialog.createDialog(window, title, throwable, message, null);
    }

    public static ExceptionDialog createDialog(Window window, String title, Throwable throwable, String[] additionalInfo) {
        return new DetailedExceptionDialog(window, title, throwable, additionalInfo);
    }

    public static ExceptionDialog createDialog(Window window, String title, Throwable throwable, String message, String[] additionalInfo) {
        return new SimpleExceptionDialog(window, title, throwable, message, additionalInfo);
    }

    public static void adjustEqualSizes(JComponent ... comps) {
        int i;
        Dimension dim = new Dimension(0, 0);
        for (i = 0; i < comps.length; ++i) {
            Dimension pref = comps[i].getPreferredSize();
            double h = Math.max(dim.getHeight(), pref.getHeight());
            double w = Math.max(dim.getWidth(), pref.getWidth());
            dim.setSize(w, h);
        }
        for (i = 0; i < comps.length; ++i) {
            comps[i].setPreferredSize(dim);
        }
    }

    public void center() {
        this.center(this.getOwner());
    }

    public void center(Window window) {
        int minY;
        JFrame jframe;
        int windowState;
        if (window == null) {
            GUIUtils.centerOnScreen(this);
            return;
        }
        if (window instanceof JFrame && ((windowState = (jframe = (JFrame)window).getExtendedState()) & 6) != 0) {
            GUIUtils.centerOnScreen(this);
            return;
        }
        Dimension currentSize = this.getSize();
        Dimension windowSize = window.getSize();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        int minX = window.getX() + (windowSize.width - currentSize.width) / 2;
        if (minX + currentSize.width > screenSize.width) {
            minX = screenSize.width - currentSize.width;
        }
        if (minX < 0) {
            minX = 0;
        }
        if ((minY = window.getY() + (windowSize.height - currentSize.height) / 2) + currentSize.height > screenSize.height) {
            minY = screenSize.height - currentSize.height;
        }
        if (minY < 0) {
            minY = 0;
        }
        this.setLocation(minX, minY);
    }

    final class DetailThrowableAction
    extends CloseAction {
        protected DetailThrowableAction(ExceptionDialog owner) {
            super(owner, LNG.get(ExceptionDialog.class.getSimpleName() + ".errorDetails"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            super.actionPerformed(e);
            ExceptionDialog dialog = ExceptionDialog.createDialog((Window)this.owner, this.owner.getTitle(), this.owner._throwable, this.owner.additionalInfo);
            dialog.setVisible(true);
        }
    }

    class CloseAction
    extends AbstractAction {
        protected ExceptionDialog owner;

        protected CloseAction(ExceptionDialog owner) {
            this(owner, LNG.get(ExceptionDialog.class.getSimpleName() + ".close"));
        }

        protected CloseAction(ExceptionDialog owner, String text) {
            super(text);
            this.owner = owner;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.owner.dispose();
        }
    }

    private static final class SimpleExceptionDialog
    extends ExceptionDialog {
        public SimpleExceptionDialog(Window owner, String title, Throwable throwable, String message, String[] additionalInfo) {
            super(owner, title, throwable, additionalInfo);
            this.buildGui(message);
        }

        private void buildGui(String message) {
            this.getContentPane().setLayout(new BorderLayout());
            this.getContentPane().add((Component)this.makeIconPanel(), "West");
            this.getContentPane().add((Component)this.makeMainPanel(message), "Center");
            this.pack();
            this.center();
        }

        private JPanel makeIconPanel() {
            JPanel panel = new JPanel();
            panel.add(new JLabel(UIManager.getIcon("OptionPane.errorIcon")));
            return panel;
        }

        private JPanel makeMainPanel(String message) {
            JPanel mainPanel = new JPanel(new GridBagLayout());
            GridBagConstraints c = new GridBagConstraints();
            c.insets = new Insets(12, 12, 11, 11);
            c.anchor = 10;
            c.weightx = 1.0;
            c.weighty = 1.0;
            mainPanel.add((Component)this.makeInfoPanel(message), c);
            c.gridy = 1;
            c.anchor = 14;
            c.insets = new Insets(17, 12, 11, 11);
            mainPanel.add((Component)this.makeButtonsPanel(), c);
            return mainPanel;
        }

        private JPanel makeInfoPanel(String message) {
            JComponent label;
            JPanel panel = new JPanel(new GridBagLayout());
            GridBagConstraints c = new GridBagConstraints();
            c.insets = new Insets(0, 0, 0, 0);
            c.fill = 2;
            if (message == null || message.isEmpty() || message.startsWith("<html>")) {
                label = new JLabel(message);
                panel.add((Component)label, c);
            } else {
                label = new JMultilineLabel();
                ((JMultilineLabel)label).setMaxWidth(550);
                ((JMultilineLabel)label).setJustified(false);
                ((JMultilineLabel)label).setText(message);
                panel.add((Component)label, c);
            }
            c.gridy = 1;
            c.insets = new Insets(12, 0, 0, 0);
            JLabel jwhere = new JLabel(Utils.getString(this.getClass(), "executionError"));
            panel.add((Component)jwhere, c);
            c.gridy = 2;
            c.insets = new Insets(0, 0, 0, 0);
            panel.add((Component)new JLabel(Utils.getString(this.getClass(), "contactError")), c);
            return panel;
        }

        private JPanel makeButtonsPanel() {
            JPanel panel = new JPanel();
            JButton detailButton = new JButton(new DetailThrowableAction(this));
            JButton closeButton = new JButton(new CloseAction(this));
            SimpleExceptionDialog.adjustEqualSizes(detailButton, closeButton);
            panel.add(detailButton);
            panel.add(closeButton);
            return panel;
        }
    }

    private static final class DetailedExceptionDialog
    extends ExceptionDialog {
        private static final int _MESSAGE_COLUMNS = 80;
        private static final int _MESSAGE_ROWS = 4;
        private static final int _STACK_TRACE_COLUMNS = 80;
        private static final int _STACK_TRACE_ROWS = 14;
        private static final int _TROUBLE_TREE_WIDTH = 800;
        private static final int _TROUBLE_TREE_HEIGHT = 100;
        private JTextArea _messageTextArea;
        private JTextArea _stackTraceTextArea;
        private JTree _throwableTree;

        public DetailedExceptionDialog(Window owner, String title, Throwable throwable, String[] additionalInfo) {
            super(owner, title, throwable, additionalInfo);
            this.createComponents();
        }

        private void createComponents() {
            Color inactiveColor = UIManager.getDefaults().getColor("TextField.inactiveBackground");
            JLabel troubleTreeLabel = new JLabel(Utils.getString(this.getClass(), "exceptionTree"));
            this._throwableTree = new JTree(new ThrowableTreeNode(this._throwable));
            this._throwableTree.addTreeSelectionListener(new TreeSelectionListener(){

                @Override
                public void valueChanged(TreeSelectionEvent e) {
                    DetailedExceptionDialog.this.updateFields();
                }
            });
            this._throwableTree.getSelectionModel().setSelectionMode(1);
            JScrollPane scrollTroubleTree = new JScrollPane(this._throwableTree);
            scrollTroubleTree.setPreferredSize(new Dimension(800, 100));
            JLabel messageLabel = new JLabel(Utils.getString(this.getClass(), "exceptionMessage"));
            this._messageTextArea = new JTextArea(this._throwable.getLocalizedMessage());
            this._messageTextArea.setColumns(80);
            this._messageTextArea.setRows(4);
            this._messageTextArea.setEditable(false);
            this._messageTextArea.setBackground(inactiveColor);
            JLabel stackTraceLabel = new JLabel(Utils.getString(this.getClass(), "stackTrace"));
            this._stackTraceTextArea = new JTextArea(this.getStackTraceText(this._throwable.getStackTrace()));
            this._stackTraceTextArea.setColumns(80);
            this._stackTraceTextArea.setRows(14);
            this._stackTraceTextArea.setEditable(false);
            this._stackTraceTextArea.setBackground(inactiveColor);
            JPanel buttonsPanel = this.createButtonPanel();
            this.setLayout(new GridBagLayout());
            JScrollPane msgScrollPane = new JScrollPane(this._messageTextArea);
            JScrollPane stackTraceScroll = new JScrollPane(this._stackTraceTextArea);
            Insets li = new Insets(5, 6, 0, 10);
            Insets fi = new Insets(3, 10, 5, 10);
            int y = 0;
            this.add((Component)troubleTreeLabel, new GBC(0, y++).west().insets(li));
            this.add((Component)scrollTroubleTree, new GBC(0, y++).both().insets(fi));
            this.add((Component)messageLabel, new GBC(0, y++).west().insets(li));
            this.add((Component)msgScrollPane, new GBC(0, y++).both().insets(fi));
            this.add((Component)stackTraceLabel, new GBC(0, y++).west().insets(li));
            this.add((Component)stackTraceScroll, new GBC(0, y++).both().insets(fi));
            this.add((Component)buttonsPanel, new GBC(0, y++).center().insets(7));
            this.pack();
            this.center();
        }

        private JPanel createButtonPanel() {
            JPanel panel = new JPanel();
            JButton closeButton = new JButton(new CloseAction(this));
            DetailedExceptionDialog.adjustEqualSizes(closeButton);
            panel.add(closeButton);
            return panel;
        }

        private void updateFields() {
            ThrowableTreeNode node = (ThrowableTreeNode)this._throwableTree.getSelectionPath().getLastPathComponent();
            if (node == null) {
                node = (ThrowableTreeNode)this._throwableTree.getModel().getRoot();
            }
            this._messageTextArea.setText(node.getThrowable().getLocalizedMessage());
            this._stackTraceTextArea.setText(this.getStackTraceText(node.getThrowable().getStackTrace()));
        }

        private String getStackTraceText(StackTraceElement[] stackTrace) {
            String text = "";
            for (int i = 0; i < stackTrace.length; ++i) {
                text = text + stackTrace[i] + "\n";
            }
            return text;
        }
    }
}

