/*
 * Decompiled with CFR 0.152.
 */
package busexplorer.panel.authorizations;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import tecgraf.openbus.core.v2_0.services.offer_registry.admin.v1_0.RegisteredEntityDesc;

public class AuthorizationWrapper {
    private RegisteredEntityDesc desc;
    private final String id;
    private final String interfaceName;

    public AuthorizationWrapper(RegisteredEntityDesc desc, String interfaceName) {
        this.desc = desc;
        this.id = desc.id;
        this.interfaceName = interfaceName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AuthorizationWrapper)) {
            return false;
        }
        AuthorizationWrapper other = (AuthorizationWrapper)o;
        return this.id.equals(other.id) && this.interfaceName.equals(other.interfaceName);
    }

    public int hashCode() {
        return this.id.hashCode() ^ this.interfaceName.hashCode();
    }

    public String getInterface() {
        return this.interfaceName;
    }

    public String getEntityId() {
        return this.id;
    }

    public RegisteredEntityDesc getEntityDescriptor() {
        return this.desc;
    }

    public static List<AuthorizationWrapper> convertToInfo(Map<RegisteredEntityDesc, List<String>> authorizationsMap) {
        ArrayList<AuthorizationWrapper> list = new ArrayList<AuthorizationWrapper>();
        for (Map.Entry<RegisteredEntityDesc, List<String>> authorizations : authorizationsMap.entrySet()) {
            RegisteredEntityDesc entity = authorizations.getKey();
            for (String interfaceName : authorizations.getValue()) {
                list.add(new AuthorizationWrapper(entity, interfaceName));
            }
        }
        return list;
    }
}

