/*
 * Decompiled with CFR 0.152.
 */
package busexplorer.panel.entities;

import busexplorer.Application;
import busexplorer.exception.handling.ExceptionContext;
import busexplorer.exception.handling.ExceptionHandler;
import busexplorer.panel.ActionType;
import busexplorer.panel.OpenBusAction;
import busexplorer.panel.entities.EntityWrapper;
import busexplorer.utils.BusExplorerTask;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.JFrame;
import tecgraf.javautils.core.lng.LNG;
import tecgraf.openbus.admin.BusAdmin;

public class EntityRefreshAction
extends OpenBusAction<EntityWrapper> {
    public EntityRefreshAction(JFrame parentWindow, BusAdmin admin) {
        super(parentWindow, admin, LNG.get(EntityRefreshAction.class.getSimpleName() + ".name"));
    }

    @Override
    public ActionType getActionType() {
        return ActionType.REFRESH;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        BusExplorerTask<List<EntityWrapper>> task = new BusExplorerTask<List<EntityWrapper>>((ExceptionHandler)Application.exceptionHandler(), ExceptionContext.BusCore){

            @Override
            protected void performTask() throws Exception {
                this.setResult(EntityWrapper.convertToInfo(EntityRefreshAction.this.admin.getEntities()));
            }

            @Override
            protected void afterTaskUI() {
                if (this.getStatus()) {
                    EntityRefreshAction.this.getTablePanelComponent().setElements((List)this.getResult());
                }
            }
        };
        task.execute(this.parentWindow, this.getString("waiting.title"), this.getString("waiting.msg"));
    }
}

