/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.standardInterceptors;

import org.jacorb.config.Configurable;
import org.jacorb.config.Configuration;
import org.jacorb.config.ConfigurationException;
import org.jacorb.orb.CDROutputStream;
import org.jacorb.orb.ORB;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.LocalObject;
import org.omg.IOP.TaggedComponent;
import org.omg.PortableInterceptor.IORInfo;
import org.omg.PortableInterceptor.IORInterceptor;
import org.omg.SSLIOP.SSL;
import org.omg.SSLIOP.SSLHelper;
import org.slf4j.Logger;

public class SSLComponentInterceptor
extends LocalObject
implements IORInterceptor,
Configurable {
    private final ORB orb;
    private final Logger logger;
    private TaggedComponent tc = null;
    private int supported = 0;
    private int required = 0;

    public SSLComponentInterceptor(ORB orb) throws ConfigurationException {
        this.orb = orb;
        this.configure(orb.getConfiguration());
        this.logger = orb.getConfiguration().getLogger(this.getClass().getName());
    }

    @Override
    public void configure(Configuration configuration) throws ConfigurationException {
        this.supported = configuration.getAttributeAsInteger("jacorb.security.ssl.server.supported_options", 32, 16);
        this.required = configuration.getAttributeAsInteger("jacorb.security.ssl.server.required_options", 0, 16);
    }

    @Override
    public String name() {
        return "SSLComponentCreator";
    }

    @Override
    public void destroy() {
    }

    @Override
    public void establish_components(IORInfo info) {
        try {
            if (this.tc == null) {
                SSL ssl = new SSL((short)this.supported, (short)this.required, (short)this.orb.getBasicAdapter().getSSLPort());
                ssl.target_supports = (short)(ssl.target_supports | 0x80);
                ssl.target_supports = (short)(ssl.target_supports | 0x20);
                CDROutputStream sslDataStream = new CDROutputStream(this.orb);
                sslDataStream.beginEncapsulatedArray();
                SSLHelper.write(sslDataStream, ssl);
                this.tc = new TaggedComponent(20, sslDataStream.getBufferCopy());
                sslDataStream.close();
                Object var3_4 = null;
            }
            info.add_ior_component_to_profile(this.tc, 0);
        }
        catch (Exception e) {
            this.logger.error("unexpected exception", e);
            throw new INTERNAL(e.toString());
        }
    }
}

