/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.diagnostic.addons.openbus.v15;

import java.text.MessageFormat;
import java.util.LinkedList;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.NO_PERMISSION;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.TRANSIENT;
import tecgraf.diagnostic.commom.Parameter;
import tecgraf.diagnostic.commom.Status;
import tecgraf.diagnostic.commom.StatusCode;
import tecgraf.diagnostic.commom.StatusEntry;
import tecgraf.diagnostic.core.monitor.AbstractMonitor;
import tecgraf.diagnostic.core.monitor.InvalidMonitorParameter;
import tecgraf.openbus.Openbus;
import tecgraf.openbus.core.v1_05.registry_service.IRegistryService;
import tecgraf.openbus.core.v1_05.registry_service.Property;
import tecgraf.openbus.core.v1_05.registry_service.ServiceOffer;

public class ServiceMonitor
extends AbstractMonitor {
    private Openbus bus;
    private String[] facets;
    private Property[] properties;

    public ServiceMonitor(String string, Openbus openbus, String[] stringArray, Property[] propertyArray) throws InvalidMonitorParameter {
        this(string, openbus, null, stringArray, propertyArray);
    }

    public ServiceMonitor(String string, Openbus openbus, String string2, String[] stringArray, Property[] propertyArray) throws InvalidMonitorParameter {
        super(string);
        this.bus = openbus;
        this.facets = stringArray != null ? stringArray : new String[0];
        if (string2 != null && string2.length() > 0) {
            if (propertyArray == null) {
                propertyArray = new Property[]{};
            }
            Property[] propertyArray2 = new Property[propertyArray.length + 1];
            for (int i = 0; i < propertyArray.length; ++i) {
                propertyArray2[i] = propertyArray[i];
            }
            propertyArray2[propertyArray2.length - 1] = new Property("registered_by", new String[]{string2});
            this.properties = propertyArray2;
        } else {
            this.properties = propertyArray == null ? new Property[0] : propertyArray;
        }
    }

    @Override
    public Status checkResource() {
        LinkedList<StatusEntry> linkedList = new LinkedList<StatusEntry>();
        try {
            StatusEntry statusEntry = this.checkRegistryService();
            linkedList.add(statusEntry);
            if (statusEntry.code != StatusCode.OK) {
                return new Status(this.resourceName, statusEntry.code, statusEntry.message, linkedList.toArray(new StatusEntry[0]), this.buildStatusParameters());
            }
            statusEntry = this.checkService();
            linkedList.add(statusEntry);
            if (statusEntry.code != StatusCode.OK) {
                return new Status(this.resourceName, statusEntry.code, statusEntry.message, linkedList.toArray(new StatusEntry[0]), this.buildStatusParameters());
            }
            String string = MessageFormat.format("O servi\u00e7o {0} est\u00e1 publicado e acess\u00edvel no barramento", this.resourceName);
            return new Status(this.resourceName, StatusCode.OK, string, linkedList.toArray(new StatusEntry[0]), this.buildStatusParameters());
        }
        catch (TRANSIENT tRANSIENT) {
            return new Status(this.resourceName, StatusCode.UNAVAILABLE, "Falha moment\u00e2nea de acesso ao barramento", linkedList.toArray(new StatusEntry[0]), this.buildStatusParameters());
        }
        catch (COMM_FAILURE cOMM_FAILURE) {
            return new Status(this.resourceName, StatusCode.UNAVAILABLE, "Falha na comunica\u00e7\u00e3o com o barramento", linkedList.toArray(new StatusEntry[0]), this.buildStatusParameters());
        }
        catch (NO_PERMISSION nO_PERMISSION) {
            return new Status(this.resourceName, StatusCode.UNAVAILABLE, "Falha de permiss\u00e3o ao acessar o barramento", linkedList.toArray(new StatusEntry[0]), this.buildStatusParameters());
        }
        catch (SystemException systemException) {
            return new Status(this.resourceName, StatusCode.UNAVAILABLE, "Falha no barramento", linkedList.toArray(new StatusEntry[0]), this.buildStatusParameters());
        }
    }

    private StatusEntry checkRegistryService() {
        if (this.bus.getRegistryService() == null) {
            String string = "O servi\u00e7o de registro do barramento est\u00e1 indispon\u00edvel";
            return new StatusEntry(StatusCode.ERROR, string);
        }
        String string = "O servi\u00e7o de registro do barramento est\u00e1 dispon\u00edvel";
        return new StatusEntry(StatusCode.OK, string);
    }

    private StatusEntry checkService() {
        IRegistryService iRegistryService = this.bus.getRegistryService();
        ServiceOffer[] serviceOfferArray = iRegistryService.findByCriteria(this.facets, this.properties);
        if (serviceOfferArray.length == 0) {
            String string = MessageFormat.format("O servi\u00e7o {0} n\u00e3o est\u00e1 publicado no barramento", this.resourceName);
            return new StatusEntry(StatusCode.UNAVAILABLE, string);
        }
        if (serviceOfferArray.length == 1) {
            try {
                serviceOfferArray[0].member._non_existent();
                String string = MessageFormat.format("O servi\u00e7o {0} est\u00e1 publicado no barramento", this.resourceName);
                return new StatusEntry(StatusCode.OK, string);
            }
            catch (TRANSIENT tRANSIENT) {
                String string = MessageFormat.format("O servi\u00e7o {0} n\u00e3o est\u00e1 ativo no barramento", this.resourceName);
                return new StatusEntry(StatusCode.ERROR, string);
            }
        }
        String string = MessageFormat.format("Encontrado mais de um servi\u00e7o semelhante ao {0} publicado no barramento", this.resourceName);
        return new StatusEntry(StatusCode.ERROR, string);
    }

    private Parameter[] buildStatusParameters() {
        LinkedList<Parameter> linkedList = new LinkedList<Parameter>();
        linkedList.add(new Parameter("facets", this.facets));
        for (Property property : this.properties) {
            linkedList.add(new Parameter(property.name, property.value));
        }
        return linkedList.toArray(new Parameter[0]);
    }
}

