/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.javautils.core.lng;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;

public class LNG {
    private static HierarchicalResourceBundle bundleHierarchy;
    private static Locale nativeLocale;
    private static TranslationListener callback;

    public static void load(String baseName, Locale locale) {
        LNG.preLoadValidations(baseName, locale);
        ResourceBundle bundle = ResourceBundle.getBundle(baseName, locale);
        if (nativeLocale != null && !LNG.inTheSameIdiom(bundle.getLocale(), nativeLocale)) {
            LNG.addResourceBundle(ResourceBundle.getBundle(baseName, nativeLocale), nativeLocale);
        }
        LNG.addResourceBundle(bundle, locale);
    }

    private static boolean inTheSameIdiom(Locale locale, Locale other) {
        if (locale == null || other == null) {
            return false;
        }
        return locale.getCountry().equals(other.getCountry()) && locale.getLanguage().equals(other.getLanguage());
    }

    public static void setNativeLocale(Locale locale) {
        Locale.setDefault(locale);
        nativeLocale = locale;
    }

    public static Locale getNativeLocale() {
        return nativeLocale;
    }

    public static void setTranslationListener(TranslationListener callback) {
        LNG.callback = callback;
    }

    public static void loadURL(String pathPrefix, String baseName, final Locale locale) throws IOException {
        LNG.preLoadValidations(baseName, locale);
        String addr = pathPrefix;
        if (!pathPrefix.endsWith("/")) {
            addr = addr + "/";
        }
        addr = addr + baseName + "_" + locale + ".properties";
        URL url = new URL(addr);
        InputStream in = url.openStream();
        PropertyResourceBundle bundle = new PropertyResourceBundle(in){

            @Override
            public Locale getLocale() {
                return locale;
            }
        };
        LNG.addResourceBundle(bundle, locale);
    }

    private static void preLoadValidations(String baseName, Locale locale) {
        if (baseName == null) {
            throw new IllegalArgumentException("baseName == null");
        }
        if (locale == null) {
            throw new IllegalArgumentException("locale == null");
        }
        if (bundleHierarchy != null) {
            if (!LNG.isLocaleAllowed(locale)) {
                throw new IllegalArgumentException("locale atual (" + bundleHierarchy.getLocale() + ") \u00e9 incompat\u00edvel com " + locale);
            }
        } else {
            LNG.load(locale);
        }
    }

    private static void addResourceBundle(ResourceBundle bundle, Locale locale) {
        HierarchicalResourceBundle newHierarchy;
        bundleHierarchy = newHierarchy = new HierarchicalResourceBundle(bundle, locale, bundleHierarchy);
    }

    public static void load(Locale locale) {
        if (locale == null) {
            throw new IllegalArgumentException("locale == null");
        }
        if (bundleHierarchy != null) {
            throw new IllegalStateException("As propriedades da biblioteca j\u00e1 foram carregadas com o Locale " + bundleHierarchy.getLocale() + ".");
        }
        LNG.loadLibraryProperties(locale);
    }

    private static void loadLibraryProperties(Locale locale) {
        ResourceBundle libBundle = ResourceBundle.getBundle("javautils_lng", locale);
        bundleHierarchy = new HierarchicalResourceBundle(libBundle);
    }

    private static boolean isLocaleAllowed(Locale locale) {
        return true;
    }

    public static boolean hasKey(String key) {
        if (key == null) {
            throw new IllegalArgumentException("key == null");
        }
        if (bundleHierarchy == null) {
            LNG.load(Locale.getDefault());
        }
        return bundleHierarchy.has(key);
    }

    public static String get(String key) {
        if (key == null) {
            throw new IllegalArgumentException("key == null");
        }
        if (bundleHierarchy == null) {
            LNG.load(Locale.getDefault());
        }
        return bundleHierarchy.get(key);
    }

    public static String getAnyOf(String ... keys) {
        String text;
        if (keys == null || keys.length == 0) {
            throw new IllegalArgumentException("pelo menos uma chave deve ser fornecida");
        }
        if (bundleHierarchy == null) {
            LNG.load(Locale.getDefault());
        }
        return (text = bundleHierarchy.getAnyOf(keys)) != null ? text : LNG.missingKeyMsg(keys[0]);
    }

    static void unload() {
        bundleHierarchy = null;
    }

    public static Locale getLocale() {
        if (bundleHierarchy == null) {
            LNG.load(Locale.getDefault());
        }
        return bundleHierarchy.getLocale();
    }

    public static String get(String key, Object[] args) {
        if (args == null) {
            throw new IllegalArgumentException("args == null");
        }
        if (args.length == 0) {
            throw new IllegalArgumentException("args.length == 0");
        }
        String pattern = LNG.get(key);
        return MessageFormat.format(pattern, args);
    }

    public static HierarchicalResourceBundle getBundleHierarchy() {
        return bundleHierarchy;
    }

    private static String missingKeyMsg(String key) {
        String defaultText = "<<<" + key + ">>>";
        if (callback != null) {
            return callback.keyNotFound(key, defaultText);
        }
        System.err.println("[LNG] Chave n\u00e3o encontrada: " + key);
        return defaultText;
    }

    public static final class HierarchicalResourceBundle {
        private HierarchicalResourceBundle parentHierarchy;
        private ResourceBundle bundle;
        private final Locale locale;

        HierarchicalResourceBundle(ResourceBundle bundle) {
            this(bundle, bundle.getLocale(), null);
        }

        HierarchicalResourceBundle(ResourceBundle bundle, Locale locale, HierarchicalResourceBundle parentHierarchy) {
            this.bundle = bundle;
            this.locale = locale;
            this.parentHierarchy = parentHierarchy;
        }

        Locale getLocale() {
            return this.locale;
        }

        boolean has(String key) {
            try {
                this.bundle.getString(key);
                return true;
            }
            catch (MissingResourceException ex1) {
                if (this.parentHierarchy != null) {
                    return this.parentHierarchy.has(key);
                }
                return false;
            }
        }

        String get(String key) {
            try {
                String text = this.bundle.getString(key);
                if (callback != null && !LNG.inTheSameIdiom(this.bundle.getLocale(), this.getLocale())) {
                    return callback.keyNotFoundInDefaultLanguage(key, text);
                }
                return text;
            }
            catch (MissingResourceException ex1) {
                if (this.parentHierarchy == null) {
                    return LNG.missingKeyMsg(key);
                }
                try {
                    return this.parentHierarchy.get(key);
                }
                catch (MissingResourceException ex2) {
                    return LNG.missingKeyMsg(key);
                }
            }
        }

        String getAnyOf(String ... keys) {
            for (String key : keys) {
                try {
                    return this.bundle.getString(key);
                }
                catch (MissingResourceException e) {
                }
            }
            if (this.parentHierarchy != null) {
                return this.parentHierarchy.getAnyOf(keys);
            }
            return null;
        }

        public ResourceBundle getBundle() {
            return this.bundle;
        }

        public HierarchicalResourceBundle getParentHierarchy() {
            return this.parentHierarchy;
        }
    }

    public static interface TranslationListener {
        public String keyNotFound(String var1, String var2);

        public String keyNotFoundInDefaultLanguage(String var1, String var2);
    }
}

