/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.javautils.gui.crud.gui.edition;

import java.awt.Container;
import javax.swing.JPanel;
import tecgraf.javautils.gui.crud.IRegistrationEditionPanel;
import tecgraf.javautils.gui.crud.gui.main.RegistrationMainPanel;
import tecgraf.javautils.gui.crud.gui.main.RegistrationModeListener;

public abstract class RegistrationEditionPanel<M, I>
implements IRegistrationEditionPanel<I> {
    private final RegistrationMainPanel<M, I> mainPanel;
    private JPanel registrationEditPanel;

    public RegistrationEditionPanel(RegistrationMainPanel<M, I> mainPanel) {
        this.mainPanel = mainPanel;
        this.addAddModeListener();
        this.addViewModeListener();
        this.addEditModeListener();
    }

    private void addAddModeListener() {
        this.mainPanel.addModeListener(new RegistrationModeListener(){

            @Override
            public void modeChanged(RegistrationMainPanel.Mode oldMode, RegistrationMainPanel.Mode newMode) {
                if (newMode == RegistrationMainPanel.Mode.ADD) {
                    RegistrationEditionPanel.this.clearIHC();
                    RegistrationEditionPanel.this.setReadOnlyIHC(false);
                }
            }
        });
    }

    private void addEditModeListener() {
        this.mainPanel.addModeListener(new RegistrationModeListener(){

            @Override
            public void modeChanged(RegistrationMainPanel.Mode oldMode, RegistrationMainPanel.Mode newMode) {
                if (newMode == RegistrationMainPanel.Mode.EDIT) {
                    Object object = RegistrationEditionPanel.this.mainPanel.getSelectedIHCObject();
                    if (object != null) {
                        RegistrationEditionPanel.this.setObjectToIHC(object);
                    }
                    RegistrationEditionPanel.this.setReadOnlyIHC(false);
                }
            }
        });
    }

    private void addViewModeListener() {
        this.mainPanel.addModeListener(new RegistrationModeListener(){

            @Override
            public void modeChanged(RegistrationMainPanel.Mode oldMode, RegistrationMainPanel.Mode newMode) {
                if (newMode == RegistrationMainPanel.Mode.VIEW) {
                    RegistrationEditionPanel.this.clearIHC();
                    Object object = RegistrationEditionPanel.this.mainPanel.getSelectedIHCObject();
                    if (object != null) {
                        RegistrationEditionPanel.this.setObjectToIHC(object);
                    }
                    RegistrationEditionPanel.this.setReadOnlyIHC(true);
                }
            }
        });
    }

    public void signalObjectEdited(boolean flag) {
        this.mainPanel.signalObjectEdited(flag);
    }

    public Container getContainer() {
        if (this.registrationEditPanel == null) {
            this.registrationEditPanel = new JPanel();
        }
        return this.registrationEditPanel;
    }

    @Override
    public abstract I getObjectFromIHC();

    @Override
    public abstract void setObjectToIHC(I var1);

    @Override
    public abstract void setReadOnlyIHC(boolean var1);

    @Override
    public abstract void clearIHC();
}

