/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.openbus.assistant;

import java.security.interfaces.RSAPrivateKey;
import tecgraf.openbus.SharedAuthSecret;

public class AuthArgs {
    AuthMode mode;
    String entity;
    byte[] password;
    RSAPrivateKey privkey;
    SharedAuthSecret secret;

    public AuthArgs(String entity, byte[] password) {
        if (entity == null || password == null) {
            throw new IllegalArgumentException("Entidade e senha devem ser diferentes de nulo.");
        }
        this.entity = entity;
        this.password = password;
        this.mode = AuthMode.AuthByPassword;
    }

    public AuthArgs(String entity, RSAPrivateKey privkey) {
        if (entity == null || privkey == null) {
            throw new IllegalArgumentException("Entidade e chave privada devem ser diferentes de nulo.");
        }
        this.entity = entity;
        this.privkey = privkey;
        this.mode = AuthMode.AuthByCertificate;
    }

    public AuthArgs(SharedAuthSecret secret) {
        if (secret == null) {
            throw new IllegalArgumentException("Segredo deve ser diferente de nulo.");
        }
        this.secret = secret;
        this.mode = AuthMode.AuthBySharing;
    }

    static enum AuthMode {
        AuthByPassword,
        AuthByCertificate,
        AuthBySharing;

    }
}

