/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.openbus.core;

import java.util.Properties;
import tecgraf.openbus.exception.InvalidPropertyValue;

enum OpenBusProperty {
    LEGACY_DISABLE("legacy.disable", "false"),
    LEGACY_DELEGATE("legacy.delegate", "caller"),
    ACCESS_KEY("access.key", null),
    CACHE_SIZE("cache.size", "30");

    private final String key;
    private final String defaultValue;

    private OpenBusProperty(String key, String value) {
        this.key = key;
        this.defaultValue = value;
    }

    public String getKey() {
        return this.key;
    }

    String getProperty(Properties props) throws InvalidPropertyValue {
        String value = props.getProperty(this.key, this.defaultValue);
        switch (this) {
            case LEGACY_DISABLE: {
                value = value.toLowerCase();
                if (!value.equals("true") && !value.equals("false")) break;
                return value;
            }
            case LEGACY_DELEGATE: {
                value = value.toLowerCase();
                if (!value.equals("caller") && !value.equals("originator")) break;
                return value;
            }
            case ACCESS_KEY: {
                return value;
            }
            case CACHE_SIZE: {
                try {
                    int size = Integer.parseInt(value);
                    if (size > 0) {
                        return value;
                    }
                    break;
                }
                catch (NumberFormatException e) {
                    throw new InvalidPropertyValue(this.key, value, e);
                }
            }
            default: {
                return null;
            }
        }
        throw new InvalidPropertyValue(this.key, value);
    }
}

