package busexplorer.panel.categories;

import busexplorer.Application;
import busexplorer.panel.ActionType;
import busexplorer.panel.OpenBusAction;
import tecgraf.javautils.core.lng.LNG;
import tecgraf.openbus.admin.BusAdmin;

import javax.swing.JFrame;
import java.awt.event.ActionEvent;

/**
 * Classe de ao para criar uma categoria. Esta dispara um dilogo.
 * 
 * 
 * @author Tecgraf
 */
public class CategoryAddAction extends OpenBusAction<CategoryWrapper> {

  /**
   * Construtor da ao.
   * 
   * @param parentWindow janela me do dilogo que a ser criado pela ao
   * @param admin biblioteca de administrao
   */
  public CategoryAddAction(JFrame parentWindow, BusAdmin admin) {
    super(parentWindow, admin, LNG.get(CategoryAddAction.class.getSimpleName() +
      ".name"));
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public ActionType getActionType() {
    return ActionType.ADD;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public boolean abilityConditions() {
    return Application.login() != null && Application.login().hasAdminRights();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void actionPerformed(ActionEvent arg0) {
    new CategoryInputDialog(parentWindow, getTablePanelComponent(),
      admin).showDialog();
  }

}
