package busexplorer.panel.interfaces;

import busexplorer.Application;
import busexplorer.desktop.dialog.BusExplorerAbstractInputDialog;
import busexplorer.exception.handling.ExceptionContext;
import busexplorer.panel.TablePanelComponent;
import busexplorer.utils.BusExplorerTask;
import busexplorer.utils.Utils;
import tecgraf.javautils.core.lng.LNG;
import tecgraf.javautils.gui.GBC;
import tecgraf.openbus.admin.BusAdmin;

import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import java.awt.GridBagLayout;
import java.awt.Window;

/**
 * Classe que d a especializao necessria ao Dilogo de Cadastro de
 * Interfaces
 * 
 * @author Tecgraf
 */
public class InterfaceInputDialog extends BusExplorerAbstractInputDialog {
  private JLabel interfaceNameLabel;
  private JTextField interfaceNameField;

  private TablePanelComponent<InterfaceWrapper> panel;

  /**
   * Construtor.
   * 
   * @param parentWindow Janela me do Dilogo.
   * @param panel Painel a ser atualizado aps a adio.
   * @param admin Acesso s funcionalidade de administrao do barramento.
   */
  public InterfaceInputDialog(Window parentWindow, TablePanelComponent<InterfaceWrapper>
    panel, BusAdmin admin) {
    super(parentWindow, LNG.get(InterfaceInputDialog.class.getSimpleName() +
      ".title"), admin);
    this.panel = panel;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected boolean accept() {
    if (!hasValidFields()) {
      return false;
    }

    BusExplorerTask<Object> task =
      new BusExplorerTask<Object>(Application.exceptionHandler(),
        ExceptionContext.BusCore) {

      @Override
      protected void performTask() throws Exception {
        admin.createInterface(getInterfaceName());
      }

      @Override
      protected void afterTaskUI() {
        if (getStatus()) {
          InterfaceWrapper wrapper = new InterfaceWrapper(getInterfaceName());

          panel.refresh(null);
          panel.selectElement(wrapper, true);
        }
      }
    };

    task.execute(this, Utils.getString(this.getClass(), "waiting.title"),
      Utils.getString(this.getClass(), "waiting.msg"));
    return task.getStatus();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected JPanel buildFields() {
    JPanel panel = new JPanel(new GridBagLayout());
    GBC baseGBC = new GBC().gridx(0).insets(5).west();

    interfaceNameLabel =
      new JLabel(LNG.get("InterfaceInputDialog.interfaceName.label"));
    panel.add(interfaceNameLabel, new GBC(baseGBC).gridy(0).none());

    interfaceNameField = new JTextField(30);
    panel.add(interfaceNameField, new GBC(baseGBC).gridy(1).horizontal());

    return panel;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public boolean hasValidFields() {
    String interfaceName = interfaceNameField.getText();

    if (interfaceName.equals("")) {
      setErrorMessage(Utils.getString(this.getClass(),
        "error.validation.emptyID"));
      return false;
    }

    clearErrorMessage();
    return true;
  }

  /**
   * Obtm o nome da interface a ser adicionada.
   *
   * @return o nome da interface a ser adicionada.
   */
  private String getInterfaceName() {
    return this.interfaceNameField.getText();
  }
}
