/**
 * $Id: SimpleConfiguratorImpl.java 132621 2012-08-23 16:30:23Z fpina $
 */
package tecgraf.openbus.algorithmservice.v1_1;

import java.util.HashMap;
import java.util.Vector;

import tecgraf.openbus.algorithmservice.v1_1.parameters.EnumerationListParameter;
import tecgraf.openbus.algorithmservice.v1_1.parameters.EnumerationListParameterImpl;
import tecgraf.openbus.algorithmservice.v1_1.parameters.EnumerationParameter;
import tecgraf.openbus.algorithmservice.v1_1.parameters.EnumerationParameterImpl;
import tecgraf.openbus.algorithmservice.v1_1.parameters.RawValueParameterHelper;
import tecgraf.openbus.algorithmservice.v1_1.parameters.RawValueParameterImpl;
import tecgraf.opendreams.commontypes.v1_0.Property;

/**
 * A classe <code>SimpleConfiguratorImpl</code> implementa um valutype
 * <code>SimpleConfigurator</code>
 *
 * @author Tecgraf
 */
public class SimpleConfiguratorImpl extends SimpleConfigurator {

  /**
   * Mapa dos parmetros do algoritmo com o nome do parmetro como chave.
   */
  HashMap<String, Parameter> parametersMap = null;

  /**
   *
   */
  public SimpleConfiguratorImpl() {
    super();
    this.algorithmName = "";
    this.algorithmVersion = "";
    this.type = AlgorithmType.ALGORITHM;
    this.parameters = new Parameter[0];
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void setParameterValue(String name, IParameterValue value)
    throws ParameterDoesNotExistsException, IncorrectParamTypeException,
    InvalidParameterException {
    if (this.parametersMap == null) {
      buildParameterMap();
    }

    Parameter param = parametersMap.get(name);

    if (param == null) {
      throw new ParameterDoesNotExistsException();
    }

    String valueType = value.getIDLType();

    if (!param.type.equals(valueType)) {
      throw new IncorrectParamTypeException();
    }

    // Se o parmetro  uma enumerao simples apenas coloca o item selecionado
    if (EnumerationParameter.class.isInstance(param.value)) {
      EnumerationParameterImpl.class.cast(param.value).setSelectedItem(
        EnumerationParameterImpl.class.cast(value).selectedId);
    }
    // Se o parmetro  uma enumerao mltimpla apenas coloca os itens selecionados
    else if (EnumerationListParameter.class.isInstance(param.value)) {
      System.out.println(param.value);
      System.out.println(value);
      EnumerationListParameterImpl.class.cast(param.value).setSelectedItems(
        EnumerationListParameterImpl.class.cast(value).selectedIds);
    }
    else {
      param.value = value;
    }
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void setParameterValueAsText(String name, String valueAsText)
    throws ParameterDoesNotExistsException {
    if (this.parametersMap == null) {
      buildParameterMap();
    }

    Parameter param = parametersMap.get(name);

    if (param == null) {
      throw new ParameterDoesNotExistsException();
    }

    param.value = new RawValueParameterImpl(valueAsText);
    param.type = RawValueParameterHelper.id();
  }

  /**
   * Constri o mapa de parmetro do algoritmo utilizando o nome do parmetro
   * como chave.
   */
  private void buildParameterMap() {
    this.parametersMap = new HashMap<String, Parameter>(this.parameters.length);

    for (Parameter param : this.parameters) {
      this.parametersMap.put(param.name, param);
    }
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public Property[] getParameters() throws ConversionToTextException {
    Vector<Property> paramVector = new Vector<Property>();

    if (this.parametersMap == null) {
      buildParameterMap();
    }

    for (Parameter param : parametersMap.values()) {
      if (param.value != null) {
        paramVector.add(new Property(param.name, param.value.convertToText()));
      }
    }

    Property[] dictionary = new Property[paramVector.size()];
    return paramVector.toArray(dictionary);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public String[] getAlgoritmInfo() {
    return new String[] { "-name", this.algorithmName, "-version",
        this.algorithmVersion };
  }
}
