/**
 * $Id: InputFileParameterImpl.java 131406 2012-07-24 19:21:30Z fpina $
 */
package tecgraf.openbus.algorithmservice.v1_1.parameters;

/**
 * A classe <code>InputFileParameterImpl</code> implementa um valutype
 * <code>InputFileParameter</code>
 * 
 * @author Tecgraf
 */
public class InputFileParameterImpl extends InputFileParameter {

  /**
   * Construtor padro.
   */
  public InputFileParameterImpl() {
    this.path = "";
    this.type = "";
  }

  /**
   * Construtor que recebe o valor do parmetro.
   * 
   * @param path caminho do arquivo
   * @param type tipo do arquivo
   */
  public InputFileParameterImpl(String path, String type) {
    this.path = path;
    this.type = type;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public String convertToText() {
    return this.path + ":" + this.type;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public String getIDLType() {
    return InputFileParameterHelper.id();
  }
}
