/**
 * $Id: IntegerParameterImpl.java 131406 2012-07-24 19:21:30Z fpina $
 */
package tecgraf.openbus.algorithmservice.v1_1.parameters;

/**
 * A classe <code>IntegerParameterImpl</code> implementa um valutype
 * <code>IntegerParameter</code>
 * 
 * @author Tecgraf
 */
public class IntegerParameterImpl extends IntegerParameter {

  /**
   * Construtor padro.
   */
  public IntegerParameterImpl() {
    this.value = 0;
  }

  /**
   * Construtor que recebe o valor do parmetro.
   * 
   * @param value valor do parmetro
   */
  public IntegerParameterImpl(int value) {
    this.value = value;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public String convertToText() {
    return String.valueOf(value);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public String getIDLType() {
    return IntegerParameterHelper.id();
  }
}